<?php
require 'auth_check.php';
require 'koneksi.php';

// subquery untuk transaksi terakhir per buku
$sql = "
    SELECT 
        b.uid_buku,
        b.judul,
        b.status,
        t.aksi AS last_aksi,
        t.timestamp AS last_ts,
        m.nama AS last_peminjam
    FROM buku b
    LEFT JOIN (
        SELECT tt.*
        FROM transaksi tt
        JOIN (
            SELECT uid_buku, MAX(timestamp) AS max_ts
            FROM transaksi
            GROUP BY uid_buku
        ) x ON tt.uid_buku = x.uid_buku AND tt.timestamp = x.max_ts
    ) t ON t.uid_buku = b.uid_buku
    LEFT JOIN mahasiswa m ON m.uid_mhs = t.uid_mhs
    ORDER BY b.judul ASC
";
$res = mysqli_query($conn, $sql);
$rows = [];
while ($r = mysqli_fetch_assoc($res)) {
    $rows[] = $r;
}

$DURASI_PINJAM_HARI = 7;
?>
<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <title>Status Buku - RFID Perpustakaan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/style.css" rel="stylesheet">
</head>
<body class="app-body">
<?php include 'navbar.php'; ?>

<div class="container py-4">
    <div class="row">
        <div class="col-12">

            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    <h4 class="fw-semibold mb-1">Status Koleksi Buku</h4>
                    <small class="text-muted">
                        Informasi ketersediaan buku dan peminjam terakhir.
                    </small>
                </div>
                <div>
                    <span class="badge rounded-pill bg-secondary-subtle text-secondary">
                        Durasi pinjam standar: <?= $DURASI_PINJAM_HARI; ?> hari
                    </span>
                </div>
            </div>

            <div class="card shadow-sm app-card">
                <div class="card-body p-0">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0 table-app">
                            <thead>
                                <tr>
                                    <th style="width: 120px;">UID</th>
                                    <th>Judul</th>
                                    <th style="width: 120px;">Status</th>
                                    <th>Peminjam Terakhir</th>
                                    <th style="width: 140px;">Tgl Transaksi</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php if (empty($rows)): ?>
                                <tr>
                                    <td colspan="5" class="text-center py-4 text-muted">
                                        Belum ada data buku.
                                    </td>
                                </tr>
                            <?php else: ?>
                                <?php foreach ($rows as $r): ?>
                                    <?php
                                        $statusLabel = $r['status'] === 'dipinjam' ? 'Dipinjam' : 'Tersedia';
                                        $badgeClass  = $r['status'] === 'dipinjam' ? 'badge-status-dipinjam' : 'badge-status-tersedia';

                                        $tglTrans = $r['last_ts'] ? date('d/m/Y', strtotime($r['last_ts'])) : '-';
                                        $namaPeminjam = $r['last_peminjam'] ? $r['last_peminjam'] : '-';
                                    ?>
                                    <tr>
                                        <td class="text-monospace small"><?= htmlspecialchars($r['uid_buku']); ?></td>
                                        <td><?= htmlspecialchars($r['judul']); ?></td>
                                        <td>
                                            <span class="badge rounded-pill <?= $badgeClass; ?>">
                                                <?= $statusLabel; ?>
                                            </span>
                                        </td>
                                        <td><?= htmlspecialchars($namaPeminjam); ?></td>
                                        <td><?= $tglTrans; ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>