<?php
require 'auth_check.php';
require 'koneksi.php';

// Ambil data pengaturan saat ini
$query = mysqli_query($conn, "SELECT * FROM system_settings WHERE id = 1");
$s = mysqli_fetch_assoc($query);

// Proses Update
if (isset($_POST['update_settings'])) {
    $nama = mysqli_real_escape_string($conn, $_POST['nama_perpus']);
    $durasi = intval($_POST['durasi_pinjam']);
    $denda = intval($_POST['denda_per_hari']);
    $max = intval($_POST['max_buku']);

    $update = mysqli_query($conn, "UPDATE system_settings SET 
                nama_perpus = '$nama', 
                durasi_pinjam = '$durasi', 
                denda_per_hari = '$denda', 
                max_buku = '$max' 
                WHERE id = 1");

    if ($update) {
        echo "<script>alert('Pengaturan Berhasil Disimpan!'); window.location='settings.php';</script>";
    }
}
?>
<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Pengaturan Sistem | Pustaka Ganesha</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        :root { --pastel-bg: #FDF6F0; --pastel-sage: #7C9473; }
        body { font-family: 'Inter', sans-serif; background-color: var(--pastel-bg); }
        .app-container { max-width: 1200px; margin: 0 auto; padding: 2rem 15px; }
        .card-custom { background: #fff; border: none; border-radius: 20px; box-shadow: 0 4px 15px rgba(0,0,0,0.02); padding: 30px; }
        .form-label { font-weight: 600; color: #4b5563; font-size: 0.9rem; }
        .form-control { border-radius: 12px; border: 1px solid #e5e7eb; padding: 12px; }
        .form-control:focus { border-color: var(--pastel-sage); box-shadow: 0 0 0 0.25rem rgba(124, 148, 115, 0.1); }
        .btn-save { background: var(--pastel-sage); color: white; border: none; border-radius: 12px; font-weight: 700; padding: 12px 30px; }
        .btn-save:hover { background: #6A7F62; color: white; }
    </style>
</head>
<body>
    <?php include 'navbar_admin.php'; ?>

    <div class="app-container">
        <header class="mb-4">
            <h3 class="fw-extrabold m-0"><i class="bi bi-gear-wide-connected me-2 text-sage"></i>Pengaturan Sistem</h3>
            <p class="text-muted small">Kelola kebijakan denda dan durasi peminjaman perpustakaan.</p>
        </header>

        <div class="row">
            <div class="col-md-7">
                <div class="card-custom">
                    <form method="POST">
                        <div class="mb-4">
                            <label class="form-label">Nama Perpustakaan</label>
                            <input type="text" name="nama_perpus" class="form-control" value="<?= $s['nama_perpus'] ?>" required>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6 mb-4">
                                <label class="form-label">Durasi Pinjam (Hari)</label>
                                <div class="input-group">
                                    <input type="number" name="durasi_pinjam" class="form-control" value="<?= $s['durasi_pinjam'] ?>" required>
                                    <span class="input-group-text bg-light border-start-0" style="border-radius: 0 12px 12px 0;">Hari</span>
                                </div>
                            </div>
                            <div class="col-md-6 mb-4">
                                <label class="form-label">Denda Per Hari</label>
                                <div class="input-group">
                                    <span class="input-group-text bg-light border-end-0" style="border-radius: 12px 0 0 12px;">Rp</span>
                                    <input type="number" name="denda_per_hari" class="form-control" value="<?= $s['denda_per_hari'] ?>" required>
                                </div>
                            </div>
                        </div>

                        <div class="mb-4">
                            <label class="form-label">Maksimal Pinjam Buku (Per Mahasiswa)</label>
                            <input type="number" name="max_buku" class="form-control" value="<?= $s['max_buku'] ?>" required>
                        </div>

                        <hr class="my-4" style="opacity: 0.1;">

                        <button type="submit" name="update_settings" class="btn-save w-100">
                            <i class="bi bi-check2-circle me-2"></i> Simpan Perubahan
                        </button>
                    </form>
                </div>
            </div>

            <div class="col-md-5">
                <div class="card-custom bg-light border-0">
                    <h6 class="fw-bold mb-3"><i class="bi bi-info-circle me-2"></i> Informasi Kebijakan</h6>
                    <ul class="small text-muted ps-3">
                        <li class="mb-2"><b>Durasi Pinjam:</b> Menentukan kapan buku dianggap terlambat secara otomatis di sistem laporan.</li>
                        <li class="mb-2"><b>Denda:</b> Nilai ini akan dikalikan dengan jumlah hari keterlambatan saat mahasiswa melakukan scan pengembalian.</li>
                        <li><b>Maksimal Buku:</b> Membatasi akses mahasiswa jika masih memiliki pinjaman aktif yang belum dikembalikan.</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</body>
</html>