<?php
require 'auth_check.php';
require 'koneksi.php';

$q        = trim($_GET['q'] ?? '');
$mhs      = null;
$riwayat  = [];

if ($q !== '') {
    $keyword = mysqli_real_escape_string($conn, $q);

    // cari mahasiswa berdasarkan NIM atau Nama (ambil 1 yang paling cocok)
    $sqlMhs = "
        SELECT * FROM mahasiswa
        WHERE nim LIKE '%$keyword%' OR nama LIKE '%$keyword%'
        ORDER BY nim ASC
        LIMIT 1
    ";
    $resMhs = mysqli_query($conn, $sqlMhs);
    $mhs    = mysqli_fetch_assoc($resMhs);

    if ($mhs) {
        $uid = mysqli_real_escape_string($conn, $mhs['uid_mhs']);

        // ambil riwayat transaksi mahasiswa tsb
        $sqlTrx = "
            SELECT t.*, b.judul
            FROM transaksi t
            JOIN buku b ON t.uid_buku = b.uid_buku
            WHERE t.uid_mhs = '$uid'
            ORDER BY t.timestamp DESC
        ";
        $resTrx = mysqli_query($conn, $sqlTrx);
        while ($r = mysqli_fetch_assoc($resTrx)) {
            $riwayat[] = $r;
        }
    }
}
?>
<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <title>Riwayat Peminjaman Mahasiswa - Pustaka Ganesha</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/style.css" rel="stylesheet">
</head>
<body class="app-body">
<?php include 'navbar.php'; ?>

<div class="container py-4">
    <div class="row">
        <div class="col-lg-10 mx-auto">

            <!-- JUDUL -->
            <div class="mb-3">
                <h4 class="fw-semibold mb-1">Riwayat Peminjaman Mahasiswa</h4>
                <small class="text-muted">
                    Cari menggunakan <strong>NIM</strong> atau <strong>nama</strong> mahasiswa.
                </small>
            </div>

            <!-- KARTU PENCARIAN -->
            <div class="card shadow-sm app-card mb-4">
                <div class="card-body">

                    <form method="get" class="mb-0">
                        <label class="form-label fw-semibold small text-uppercase text-muted">
                            Pencarian Mahasiswa
                        </label>

                        <!-- input & tombol sejajar -->
                        <div class="input-group input-group-lg">
                            <input
                                type="text"
                                name="q"
                                class="form-control"
                                placeholder="Contoh: 23313006 atau Dwi Khoirul"
                                value="<?= htmlspecialchars($q); ?>"
                                required
                            >
                            <button class="btn btn-primary px-4" type="submit">
                                Cari
                            </button>
                        </div>

                        <div class="form-text mt-1">
                            Ketik NIM lengkap atau sebagian nama lalu klik <strong>Cari</strong>.
                        </div>
                    </form>

                </div>
            </div>

            <!-- HASIL -->
            <?php if ($q !== '' && !$mhs): ?>
                <div class="alert alert-warning app-alert">
                    Mahasiswa dengan kata kunci <strong><?= htmlspecialchars($q); ?></strong> tidak ditemukan.
                </div>
            <?php endif; ?>

            <?php if ($mhs): ?>
                <!-- INFO MAHASISWA -->
                <div class="card shadow-sm app-card mb-3">
                    <div class="card-body">
                        <div class="d-flex flex-column flex-md-row justify-content-between align-items-md-center gap-2">
                            <div>
                                <div class="small text-muted text-uppercase mb-1">Mahasiswa</div>
                                <h5 class="mb-0"><?= htmlspecialchars($mhs['nama']); ?></h5>
                                <div class="text-muted">
                                    NIM <?= htmlspecialchars($mhs['nim']); ?> ·
                                    <?= htmlspecialchars($mhs['prodi']); ?>
                                </div>
                            </div>
                            <div class="text-md-end">
                                <span class="badge rounded-pill bg-primary-subtle text-primary">
                                    UID: <?= htmlspecialchars($mhs['uid_mhs']); ?>
                                </span>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- TABEL RIWAYAT -->
                <div class="card shadow-sm app-card">
                    <div class="card-header bg-white border-0 d-flex justify-content-between align-items-center">
                        <span class="fw-semibold">Riwayat Transaksi</span>
                        <small class="text-muted">
                            Total: <?= count($riwayat); ?> transaksi
                        </small>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table table-hover mb-0 table-app">
                                <thead>
                                    <tr>
                                        <th style="width:150px;">Tanggal</th>
                                        <th style="width:120px;">Jam</th>
                                        <th>Judul Buku</th>
                                        <th style="width:110px;">Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php if (empty($riwayat)): ?>
                                    <tr>
                                        <td colspan="4" class="text-center py-4 text-muted">
                                            Belum ada transaksi untuk mahasiswa ini.
                                        </td>
                                    </tr>
                                <?php else: ?>
                                    <?php foreach ($riwayat as $r): ?>
                                        <?php
                                            $tgl = date('d/m/Y', strtotime($r['timestamp']));
                                            $jam = date('H:i:s', strtotime($r['timestamp']));
                                        ?>
                                        <tr>
                                            <td><?= $tgl; ?></td>
                                            <td><?= $jam; ?></td>
                                            <td><?= htmlspecialchars($r['judul']); ?></td>
                                            <td>
                                                <?php if ($r['aksi'] === 'PINJAM'): ?>
                                                    <span class="badge rounded-pill badge-aksi-pinjam">PINJAM</span>
                                                <?php else: ?>
                                                    <span class="badge rounded-pill badge-aksi-kembali">KEMBALI</span>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            <?php else: ?>
                <?php if ($q === ''): ?>
                    <div class="alert alert-info app-alert">
                        Masukkan kata kunci NIM atau nama mahasiswa lalu klik <strong>Cari</strong> untuk melihat riwayat transaksi.
                    </div>
                <?php endif; ?>
            <?php endif; ?>

        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>