<?php
// file: notif_config.php

// ============ KONFIGURASI NOTIF (WhatsApp / SMS) ============
// Sementara ini kita buat stub saja.
// Nanti kalau sudah punya API WA, implement di fungsi sendWhatsApp().

function sendWhatsApp(string $nohp, string $pesan): void
{
    // Contoh jika pakai API (pseudo):
    // $token = 'API_KEY_MU';
    // $url   = 'https://api-whatsapp-mu/send-message';
    //
    // $payload = [
    //   'target' => $nohp,
    //   'message'=> $pesan,
    // ];
    //
    // $ch = curl_init($url);
    // curl_setopt($ch, CURLOPT_POST, true);
    // curl_setopt($ch, CURLOPT_HTTPHEADER, [
    //     'Authorization: Bearer ' . $token,
    //     'Content-Type: application/json',
    // ]);
    // curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    // curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    // $resp = curl_exec($ch);
    // curl_close($ch);

    // Untuk sekarang: hanya log ke file / echo (debug)
    // error_log("WA to $nohp: " . str_replace("\n", ' | ', $pesan));
}

// ============ FUNGSI NOTIF KHUSUS PERPUSTAKAAN ============

function kirim_notif_peminjaman(array $mhs, array $buku, int $durasi_hari, string $tgl_pinjam): void
{
    if (empty($mhs['no_hp'])) return;

    $nohp  = $mhs['no_hp'];
    $nama  = $mhs['nama'];
    $nim   = $mhs['nim'];
    $judul = $buku['judul'];

    $due = date('d/m/Y', strtotime("$tgl_pinjam +$durasi_hari day"));

    $pesan = "Halo $nama ($nim),\n\n"
        . "Peminjaman buku berhasil.\n"
        . "Judul        : $judul\n"
        . "Tanggal pinjam : " . date('d/m/Y', strtotime($tgl_pinjam)) . "\n"
        . "Durasi       : $durasi_hari hari\n"
        . "Jatuh tempo  : $due\n\n"
        . "– Pustaka Ganesha";

    sendWhatsApp($nohp, $pesan);
}

function kirim_notif_pengembalian(array $mhs, array $buku, string $tgl_kembali, int $terlambat_hari = 0): void
{
    if (empty($mhs['no_hp'])) return;

    $nohp  = $mhs['no_hp'];
    $nama  = $mhs['nama'];
    $nim   = $mhs['nim'];
    $judul = $buku['judul'];

    $statusTerlambat = $terlambat_hari > 0
        ? "Status : TERLAMBAT $terlambat_hari hari\n"
        : "Status : Tepat waktu\n";

    $pesan = "Halo $nama ($nim),\n\n"
        . "Pengembalian buku berhasil.\n"
        . "Judul            : $judul\n"
        . "Tanggal kembali  : " . date('d/m/Y H:i', strtotime($tgl_kembali)) . "\n"
        . $statusTerlambat
        . "\nTerima kasih sudah mengembalikan buku.\n"
        . "– Pustaka Ganesha";

    sendWhatsApp($nohp, $pesan);
}