<?php
if (session_status() === PHP_SESSION_NONE) session_start();
require 'koneksi.php';
$current_page = basename($_SERVER['PHP_SELF']);

// Hitung Notifikasi Reset Password yang masih pending
$q_notif = mysqli_query($conn, "SELECT COUNT(*) as total FROM password_requests WHERE status='pending'");
$notif = mysqli_fetch_assoc($q_notif)['total'] ?? 0;
?>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<style>
    :root { --sage: #7C9473; --sage-light: #F1F8F6; }
    .app-navbar { background: #ffffff !important; border-bottom: 1px solid #F0F2F5; padding: 0.6rem 0; }
    .app-navbar .container { max-width: 1200px !important; margin: 0 auto !important; }
    .navbar-brand { color: var(--sage) !important; font-weight: 800; font-size: 1.25rem; }
    .nav-link { 
        color: #6C757D !important; font-weight: 600; font-size: 0.85rem; 
        padding: 0.6rem 1rem !important; border-radius: 12px; transition: 0.3s;
        display: flex; align-items: center; gap: 8px;
    }
    .nav-link.active-page { background: var(--sage-light) !important; color: var(--sage) !important; }
    .nav-link:hover { color: var(--sage) !important; background: #F8F9FA; }
    
    /* Loading Bar & Back to Top Style */
    #loading-bar { position: fixed; top: 0; left: 0; width: 0%; height: 3px; background: var(--sage); z-index: 9999; transition: width 0.4s ease; }
    #btn-back-to-top { 
        position: fixed; bottom: 20px; right: 20px; display: none; background: var(--sage); 
        color: white; border-radius: 50%; width: 45px; height: 45px; border: none; 
        box-shadow: 0 4px 10px rgba(0,0,0,0.1); z-index: 1000; cursor: pointer; transition: 0.3s;
    }
</style>

<div id="loading-bar"></div>
<button id="btn-back-to-top"><i class="bi bi-arrow-up"></i></button>

<nav class="navbar navbar-expand-lg app-navbar shadow-sm sticky-top">
  <div class="container"> 
    <a class="navbar-brand d-flex align-items-center" href="dashboard.php">
      <i class="bi bi-book-half me-2 fs-4"></i> Pustaka Ganesha
    </a>
    <button class="navbar-toggler border-0" type="button" data-bs-toggle="collapse" data-bs-target="#adminNav">
      <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="adminNav">
      <ul class="navbar-nav ms-auto align-items-center">
        <li class="nav-item">
            <a class="nav-link <?= ($current_page == 'dashboard.php') ? 'active-page' : ''; ?>" href="dashboard.php">
                <i class="bi bi-grid-1x2-fill"></i> Dashboard
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?= ($current_page == 'buku.php') ? 'active-page' : ''; ?>" href="buku.php">
                <i class="bi bi-book-fill"></i> Buku
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?= ($current_page == 'mhs.php') ? 'active-page' : ''; ?>" href="mhs.php">
                <i class="bi bi-people-fill"></i> Mahasiswa
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?= ($current_page == 'laporan.php') ? 'active-page' : ''; ?>" href="laporan.php">
                <i class="bi bi-file-earmark-bar-graph-fill"></i> Laporan
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link position-relative <?= ($current_page == 'password_approve.php') ? 'active-page' : ''; ?>" href="password_approve.php">
                <i class="bi bi-shield-lock-fill"></i> Reset PW
                <?php if($notif > 0): ?>
                <span class="position-absolute top-0 start-100 translate-middle badge rounded-pill bg-danger border border-white" style="font-size:0.65rem;"><?= $notif ?></span>
                <?php endif; ?>
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link <?= ($current_page == 'settings.php') ? 'active-page' : ''; ?>" href="settings.php">
                <i class="bi bi-gear-fill"></i> Settings
            </a>
        </li>
        <li class="nav-item ms-lg-3">
            <a class="btn btn-sm px-4 rounded-pill" href="logout.php" style="background: #FFE5E5; color: #D63031; font-weight: 600; font-size: 0.8rem;">
                <i class="bi bi-box-arrow-right me-1"></i> Logout
            </a>
        </li>
      </ul>
    </div>
  </div>
</nav>

<script>
    // YouTube Style Loading Bar
    window.addEventListener('load', function() {
        const bar = document.getElementById('loading-bar');
        bar.style.width = '100%';
        setTimeout(() => { bar.style.opacity = '0'; }, 500);
    });

    // Back to Top functionality
    window.onscroll = function() {
        const btn = document.getElementById("btn-back-to-top");
        if (document.documentElement.scrollTop > 300) btn.style.display = "block";
        else btn.style.display = "none";
    };
    document.getElementById("btn-back-to-top").onclick = function() {
        window.scrollTo({top: 0, behavior: 'smooth'});
    };

    // --- LOGIKA NOTIFIKASI GLOBAL REAL-TIME ---
    let lastLogId = localStorage.getItem('globalLastLogId') || 0;

    function checkGlobalRfidScan() {
        fetch('api/live_panel.php')
            .then(response => response.json())
            .then(data => {
                if (data.status === 'ok' && data.id_log > lastLogId) {
                    lastLogId = data.id_log;
                    localStorage.setItem('globalLastLogId', lastLogId);

                    // Tentukan warna dan label dinamis
                    const isError = data.log_status !== 'ok';
                    const mainColor = isError ? '#D63031' : '#7C9473';
                    const bgColor = isError ? '#FFF5F5' : '#f8f9fa';
                    const uidLabel = data.uid_buku === 'BUKU' ? 'UID BUKU' : 'UID KTM';

                    Swal.fire({
                        title: `<span style="font-size:18px; font-weight:800; color:${mainColor};">
                                    ${data.aksi}: ${data.log_status.toUpperCase()}
                                </span>`,
                        html: `
                            <div style="text-align: left; font-size: 13px; line-height: 1.6;">
                                <div style="background:${bgColor}; padding:10px; border-radius:10px; border-left:4px solid ${mainColor};">
                                    <strong>👤 Info:</strong> ${data.nama}<br>
                                    <strong>⏰ Waktu:</strong> ${data.waktu} WIB
                                </div>
                                <div style="margin-top:10px; padding:0 5px;">
                                    <strong>⚠️ Pesan:</strong> ${data.message}<br>
                                    <hr style="margin:8px 0;">
                                    <small class="text-muted">${uidLabel} : <strong>${data.uid_mhs}</strong></small>
                                </div>
                            </div>
                        `,
                        icon: isError ? 'error' : 'success',
                        toast: true,
                        position: 'top-end',
                        showConfirmButton: false,
                        showCloseButton: true,
                        timer: 15000, // 15 detik agar admin sempat membaca detail error
                        timerProgressBar: true,
                        width: '380px',
                        didOpen: (toast) => {
                            toast.addEventListener('mouseenter', Swal.stopTimer)
                            toast.addEventListener('mouseleave', Swal.resumeTimer)
                        }
                    });
                }
            })
            .catch(err => console.warn("Menunggu aktivitas RFID..."));
    }

    setInterval(checkGlobalRfidScan, 2000);
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>