<?php
require 'auth_check.php';
require 'koneksi.php'; // Jalur diperbaiki

$success = ''; $error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $uid_mhs = mysqli_real_escape_string($conn, $_POST['uid_mhs'] ?? '');
    $nim     = mysqli_real_escape_string($conn, $_POST['nim'] ?? '');
    $nama    = mysqli_real_escape_string($conn, $_POST['nama'] ?? '');
    $prodi   = mysqli_real_escape_string($conn, $_POST['prodi'] ?? '');
    if ($uid_mhs && $nim && $nama && $prodi) {
        $cek = mysqli_query($conn, "SELECT 1 FROM mahasiswa WHERE uid_mhs='$uid_mhs' OR nim='$nim'");
        if (mysqli_num_rows($cek) > 0) { $error = 'UID atau NIM sudah terdaftar!'; } 
        else {
            $sql = "INSERT INTO mahasiswa (uid_mhs, nim, nama, prodi, password) VALUES ('$uid_mhs', '$nim', '$nama', '$prodi', '".password_hash($nim, PASSWORD_DEFAULT)."')";
            if (mysqli_query($conn, $sql)) { $success = 'Berhasil didaftarkan!'; } else { $error = 'Gagal menyimpan.'; }
        }
    }
}
?>
<!doctype html>
<html lang="id">
<head>
    <title>Tambah Mahasiswa</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body style="background:#FDF6F0; padding-top:50px;">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <a href="mhs.php" class="btn btn-outline-dark mb-3 rounded-pill btn-sm"><i class="bi bi-arrow-left"></i> Kembali ke Daftar</a>
                <div class="card border-0 shadow-sm p-4" style="border-radius:20px;">
                    <h5 class="fw-bold mb-4">Form Registrasi Mahasiswa</h5>
                    <?php if($success): ?> <div class="alert alert-success border-0 small"><?= $success ?></div> <?php endif; ?>
                    <?php if($error): ?> <div class="alert alert-danger border-0 small"><?= $error ?></div> <?php endif; ?>
                    <form method="POST">
                        <div class="mb-3">
                            <label class="small fw-bold">UID Kartu KTM</label>
                            <div class="input-group">
                                <input type="text" name="uid_mhs" id="uid_mhs" class="form-control" readonly required placeholder="Scan kartu mode 'M'...">
                                <button class="btn btn-dark" type="button" onclick="ambilUid('MAHASISWA')">Ambil UID</button>
                            </div>
                        </div>
                        <div class="mb-3"><label class="small fw-bold">NIM</label><input type="text" name="nim" class="form-control" required></div>
                        <div class="mb-3"><label class="small fw-bold">Nama Lengkap</label><input type="text" name="nama" class="form-control" required></div>
                        <div class="mb-3"><label class="small fw-bold">Program Studi</label><input type="text" name="prodi" class="form-control" required></div>
                        <button type="submit" class="btn btn-success w-100 py-2 mt-2" style="background:#7C9473; border:none;">Simpan Mahasiswa</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script>
    function ambilUid(jenis) {
        fetch('api/get_latest_uid.php?jenis=' + jenis)
            .then(res => res.json())
            .then(data => {
                if(data.status==='ok') { 
                    document.getElementById('uid_mhs').value = data.uid;
                    Swal.fire({ icon: 'success', title: 'Berhasil', text: 'UID Mahasiswa disalin', timer: 1000, showConfirmButton: false });
                } else { Swal.fire('Gagal', 'Scan kartu mode M di alat dulu!', 'warning'); }
            });
    }
    </script>
</body>
</html>