<?php
require 'auth_check.php';
require 'koneksi.php';

$uid_mhs = $_SESSION['mhs_uid'];
$sql = "SELECT p.timestamp AS ts_pinjam, p.durasi_hari, p.denda, b.judul,
        k.timestamp AS ts_kembali FROM transaksi p
        JOIN buku b ON p.uid_buku = b.uid_buku
        LEFT JOIN transaksi k ON k.uid_mhs = p.uid_mhs AND k.uid_buku = p.uid_buku 
        AND k.aksi = 'KEMBALI' AND k.timestamp > p.timestamp
        WHERE p.aksi = 'PINJAM' AND p.uid_mhs = '$uid_mhs' ORDER BY p.timestamp DESC";
$res = mysqli_query($conn, $sql);
?>
<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Riwayat Pinjam | Pustaka Ganesha</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        body { font-family: 'Inter', sans-serif; background-color: #FDF6F0; margin: 0; }
        .app-container { max-width: 1200px; margin: 0 auto; padding: 2rem 15px; }
        .card-custom { background: #fff; border: none; border-radius: 20px; box-shadow: 0 4px 15px rgba(0,0,0,0.02); overflow: hidden; }
        .badge-status { padding: 5px 12px; border-radius: 50px; font-size: 11px; font-weight: 600; }
        .bg-ontime { background: #e0f2fe; color: #0369a1; }
        .bg-telat { background: #fee2e2; color: #b91c1c; }
        .bg-aktif { background: #f0f9fa; color: #457b9d; }
    </style>
</head>
<body>
    <?php include 'navbar_mhs.php'; ?>
    <div class="app-container">
        <header class="mb-4">
            <h3 class="fw-extrabold m-0 text-dark">Riwayat Peminjaman</h3>
            <p class="text-muted small">Daftar buku yang pernah dan sedang kamu pinjam.</p>
        </header>

        <div class="table-responsive">
             <table class="table table-hover">
                <thead class="table-light">
                    <tr class="small text-muted text-uppercase">
                        <th class="ps-4">Buku</th>
                        <th>Pinjam</th>
                        <th>Kembali</th>
                        <th>Status</th>
                        <th class="pe-4 text-end">Denda</th>
                    </tr>
                </thead>
                <tbody>
                    <?php while ($r = mysqli_fetch_assoc($res)): 
                        $dtPinjam = new DateTime($r['ts_pinjam']);
                        $jatuhTempo = (clone $dtPinjam)->modify("+".($r['durasi_hari'] ?? 7)." day");
                        $isKembali = !empty($r['ts_kembali']);
                        $status = $isKembali ? ($r['ts_kembali'] <= $jatuhTempo->format('Y-m-d H:i:s') ? 'Selesai' : 'Terlambat') : 'Dipinjam';
                        $class = $isKembali ? ($status == 'Selesai' ? 'bg-ontime' : 'bg-telat') : 'bg-aktif';
                    ?>
                    <tr>
                        <td class="ps-4 fw-bold text-dark small"><?= htmlspecialchars($r['judul']) ?></td>
                        <td class="small"><?= $dtPinjam->format('d/m/y') ?></td>
                        <td class="small"><?= $isKembali ? date('d/m/y', strtotime($r['ts_kembali'])) : '-' ?></td>
                        <td><span class="badge-status <?= $class ?>"><?= $status ?></span></td>
                        <td class="pe-4 text-end fw-bold <?= $r['denda'] > 0 ? 'text-danger' : 'text-muted' ?>">
                            Rp <?= number_format($r['denda'], 0, ',', '.') ?>
                        </td>
                    </tr>
                    <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </div>
</body>
</html>