<?php
require 'auth_check.php';
require 'koneksi.php';

if (empty($_SESSION['mhs_login'])) {
    header('Location: login.php');
    exit;
}

$uid_mhs = mysqli_real_escape_string($conn, $_SESSION['mhs_uid']);
$nama_session = $_SESSION['mhs_nama'];
$success = '';
$error   = '';

$sql = "SELECT * FROM mahasiswa WHERE uid_mhs = '$uid_mhs' LIMIT 1";
$res = mysqli_query($conn, $sql);
$mhs = mysqli_fetch_assoc($res);

if (!$mhs) { die('Data mahasiswa tidak ditemukan.'); }

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $pass_lama = trim($_POST['pass_lama'] ?? '');
    $pass_baru = trim($_POST['pass_baru'] ?? '');
    $pass_konf = trim($_POST['pass_konf'] ?? '');

    if ($pass_lama === '' || $pass_baru === '' || $pass_konf === '') {
        $error = 'Semua field password wajib diisi.';
    } elseif ($pass_baru !== $pass_konf) {
        $error = 'Konfirmasi password baru tidak sama.';
    } elseif (!password_verify($pass_lama, $mhs['password'])) {
        $error = 'Password lama salah.';
    } else {
        $hashPass = password_hash($pass_baru, PASSWORD_DEFAULT);
        mysqli_query($conn, "INSERT INTO password_requests (uid_mhs, password_baru, jenis, status) VALUES ('$uid_mhs', '$hashPass', 'ganti', 'pending')");
        $success = 'Permintaan ganti password berhasil dikirim ke admin.';
    }
}
?>
<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Profil Mahasiswa | Pustaka Ganesha</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        :root { --pastel-bg: #FDF6F0; --sage: #7C9473; }
        
        body { 
            font-family: 'Inter', sans-serif; 
            background-color: var(--pastel-bg); 
            margin: 0 !important; 
            padding: 0 !important; 
        }
        
        /* CONTAINER KONSTRUKSI: Harus 100% sama dengan Navbar */
        .app-container { 
            max-width: 1200px !important; 
            margin-left: auto !important; 
            margin-right: auto !important; 
            padding-left: 15px !important; 
            padding-right: 15px !important;
            padding-top: 2rem !important;
        }
        
        .card-custom { 
            background: #fff; border: none; border-radius: 20px; 
            padding: 30px; box-shadow: 0 4px 15px rgba(0,0,0,0.02); 
        }
        
        .profile-label { font-size: 0.75rem; font-weight: 700; color: #9ca3af; text-transform: uppercase; letter-spacing: 0.5px; }
        .profile-value { font-size: 1rem; font-weight: 600; color: #374151; margin-bottom: 1.5rem; }
        
        .form-control { border-radius: 12px; border: 1px solid #f0f0f0 !important; background: #fafafa; padding: 10px 15px; }
        .form-control:focus { border-color: var(--sage) !important; box-shadow: 0 0 0 0.25rem rgba(124, 148, 115, 0.1) !important; }
        
        .btn-sage { background: var(--sage); color: white; border: none; border-radius: 12px; font-weight: 700; padding: 12px; transition: 0.3s; }
        .btn-sage:hover { background: #6A7F62; transform: translateY(-2px); }
    </style>
</head>
<body>
    <?php include 'navbar_mhs.php'; ?>

    <div class="app-container">
        <header class="mb-4">
            <h3 style="font-weight: 800; color: #333; margin: 0;">Profil Mahasiswa</h3>
            <p class="text-muted small m-0">Informasi akun dan keamanan password.</p>
        </header>

        <div class="row g-4">
            <div class="col-lg-5">
                <div class="card-custom h-100">
                    <h5 class="fw-bold mb-4 text-dark"><i class="bi bi-person-badge me-2 text-sage"></i>Data Pribadi</h5>
                    <div class="profile-label">Nama Lengkap</div>
                    <div class="profile-value"><?= htmlspecialchars($mhs['nama']); ?></div>
                    <div class="profile-label">NIM</div>
                    <div class="profile-value" style="color: var(--sage);"><?= htmlspecialchars($mhs['nim']); ?></div>
                    <div class="profile-label">Program Studi</div>
                    <div class="profile-value"><?= htmlspecialchars($mhs['prodi'] ?? '-'); ?></div>
                </div>
            </div>

            <div class="col-lg-7">
                <div class="card-custom">
                    <h5 class="fw-bold mb-4 text-dark"><i class="bi bi-shield-lock me-2 text-warning"></i>Keamanan Akun</h5>
                    <?php if ($success): ?>
                        <div class="alert alert-success border-0 small rounded-4 mb-4 shadow-sm"><?= $success; ?></div>
                    <?php endif; ?>
                    <?php if ($error): ?>
                        <div class="alert alert-danger border-0 small rounded-4 mb-4 shadow-sm"><?= $error; ?></div>
                    <?php endif; ?>

                    <form method="POST">
                        <div class="mb-3">
                            <label class="form-label small fw-bold">Password Lama</label>
                            <input type="password" name="pass_lama" class="form-control" placeholder="Masukkan password saat ini" required>
                        </div>
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <label class="form-label small fw-bold">Password Baru</label>
                                <input type="password" name="pass_baru" class="form-control" placeholder="Min. 8 karakter" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label small fw-bold">Konfirmasi</label>
                                <input type="password" name="pass_konf" class="form-control" placeholder="Ulangi password baru" required>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-sage w-100 shadow-sm">Ajukan Perubahan Password</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>