<?php
require 'auth_check.php';
require 'koneksi.php';

// Pastikan hanya mahasiswa yang bisa akses
if (empty($_SESSION['mhs_login'])) {
    header("Location: login.php");
    exit;
}

$uid  = mysqli_real_escape_string($conn, $_SESSION['mhs_uid']);
$nama = $_SESSION['mhs_nama'];

// --- PROSES PERPANJANGAN MANDIRI ---
$msg_perpanjang = "";
if (isset($_POST['perpanjang'])) {
    $uid_buku_input = mysqli_real_escape_string($conn, $_POST['uid_buku_ext']);
    
    // Syarat: Hanya bisa perpanjang jika belum terlambat (sisa hari >= 0)
    // Query ini menambah durasi_hari sebanyak 3 hari
    $sql_ext = "UPDATE transaksi SET durasi_hari = durasi_hari + 3 
                WHERE uid_mhs = '$uid' AND uid_buku = '$uid_buku_input' AND aksi = 'PINJAM'
                AND NOT EXISTS (
                    SELECT 1 FROM (SELECT * FROM transaksi) AS k 
                    WHERE k.uid_buku = '$uid_buku_input' AND k.uid_mhs = '$uid' 
                    AND k.aksi = 'KEMBALI' AND k.timestamp > transaksi.timestamp
                )";
    
    if (mysqli_query($conn, $sql_ext)) {
        $msg_perpanjang = "Buku berhasil diperpanjang 3 hari!";
    }
}

// 1. AMBIL SETTING DENDA
$set = mysqli_fetch_assoc(mysqli_query($conn, "SELECT denda_per_hari FROM system_settings WHERE id=1"));
$biayaDenda = $set['denda_per_hari'] ?? 1000;

// 2. AMBIL DATA PINJAMAN AKTIF
$q = mysqli_query($conn, "
    SELECT b.judul, b.uid_buku, t.timestamp, t.durasi_hari
    FROM transaksi t
    JOIN buku b ON t.uid_buku=b.uid_buku
    WHERE t.uid_mhs='$uid'
      AND t.aksi='PINJAM'
      AND NOT EXISTS (
        SELECT 1 FROM transaksi k
        WHERE k.uid_buku=t.uid_buku
          AND k.uid_mhs=t.uid_mhs
          AND k.aksi='KEMBALI'
          AND k.timestamp>t.timestamp
      )
");

$now = new DateTime();
$pinjam = [];
$hampirJatuh = 0;
$totalDendaBerjalan = 0;

while ($r = mysqli_fetch_assoc($q)) {
    $dtPinjam = new DateTime($r['timestamp']);
    $jatuh = clone $dtPinjam;
    $jatuh->modify('+'.($r['durasi_hari'] ?? 7).' day');

    // Kalkulasi Sisa Hari & Denda
    $diff = $now->diff($jatuh);
    $sisa = $diff->days * ($now <= $jatuh ? 1 : -1);

    $dendaBuku = 0;
    if ($sisa < 0) {
        $dendaBuku = abs($sisa) * $biayaDenda;
        $totalDendaBerjalan += $dendaBuku;
    }

    if ($sisa <= 2 && $sisa >= 0) $hampirJatuh++;

    $pinjam[] = [
        'uid_buku' => $r['uid_buku'],
        'judul' => $r['judul'],
        'jatuh' => $jatuh->format('d/m/Y'),
        'sisa'  => $sisa,
        'denda' => $dendaBuku
    ];
}
?>
<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard Mahasiswa | Pustaka Ganesha</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
        :root { --pastel-bg: #FDF6F0; --sage: #7C9473; }
        body { font-family: 'Inter', sans-serif; background-color: var(--pastel-bg); margin: 0; padding: 0; }
        .app-container { max-width: 1200px; margin: 0 auto; padding: 2rem 15px; }
        .card-custom { background: #fff; border: none; border-radius: 20px; box-shadow: 0 4px 15px rgba(0,0,0,0.02); padding: 25px; }
        .stat-card { background: #fff; border: none; border-radius: 20px; padding: 20px; box-shadow: 0 4px 15px rgba(0,0,0,0.02); }
        .badge-status { padding: 5px 12px; border-radius: 50px; font-size: 11px; font-weight: 700; }
        .virtual-card { background: linear-gradient(135deg, #7C9473 0%, #9BBAB9 100%); color: white; border-radius: 25px; border: none; }
        .btn-perpanjang { font-size: 10px; padding: 4px 10px; border-radius: 8px; }
    </style>
</head>
<body>
    <?php include 'navbar_mhs.php'; ?>

    <div class="app-container">
        <header class="mb-4 d-flex justify-content-between align-items-center">
            <div>
                <h3 class="fw-extrabold m-0 text-dark">Halo, <?= htmlspecialchars($nama) ?> 👋</h3>
                <p class="text-muted small m-0">Pantau pinjaman dan denda kamu secara real-time.</p>
            </div>
            <?php if($msg_perpanjang): ?>
                <div class="alert alert-success py-2 px-3 small rounded-3 m-0 border-0 shadow-sm">
                    <i class="bi bi-check-circle-fill me-1"></i> <?= $msg_perpanjang ?>
                </div>
            <?php endif; ?>
        </header>

        <div class="row g-3 mb-4">
            <div class="col-md-4">
                <div class="stat-card border-start border-4 border-info">
                    <div class="text-muted small fw-bold text-uppercase">Pinjaman Aktif</div>
                    <h2 class="fw-extrabold m-0"><?= count($pinjam) ?></h2>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card border-start border-4 border-danger">
                    <div class="text-muted small fw-bold text-danger text-uppercase">Denda Berjalan</div>
                    <h2 class="fw-extrabold m-0 text-danger">Rp <?= number_format($totalDendaBerjalan,0,',','.') ?></h2>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card border-start border-4 border-warning">
                    <div class="text-muted small fw-bold text-uppercase">Hampir Jatuh Tempo</div>
                    <h2 class="fw-extrabold m-0 text-warning"><?= $hampirJatuh ?></h2>
                </div>
            </div>
        </div>

        <div class="row g-4">
            <div class="col-lg-8">
                <div class="card-custom">
                    <h6 class="fw-bold mb-4"><i class="bi bi-book-half me-2 text-sage"></i> Daftar Pinjaman Aktif</h6>
                    <div class="table-responsive">
                        <table class="table align-middle m-0">
                            <thead>
                                <tr class="small text-muted text-uppercase">
                                    <th>Judul Buku</th>
                                    <th>Jatuh Tempo</th>
                                    <th class="text-end">Opsi / Status / Denda</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php if(empty($pinjam)): ?>
                                <tr><td colspan="3" class="text-center py-5 text-muted small">Tidak ada buku yang sedang dipinjam.</td></tr>
                                <?php else: ?>
                                    <?php foreach ($pinjam as $p): ?>
                                    <tr>
                                        <td><div class="fw-bold text-dark small"><?= htmlspecialchars($p['judul']) ?></div></td>
                                        <td class="small text-muted"><?= $p['jatuh'] ?></td>
                                        <td class="text-end">
                                            <div class="d-flex flex-column align-items-end gap-1">
                                                <?php if ($p['sisa'] < 0): ?>
                                                    <div class="text-danger small fw-bold">Rp <?= number_format($p['denda'],0,',','.') ?></div>
                                                    <span class="badge-status bg-danger text-white">TERLAMBAT</span>
                                                <?php else: ?>
                                                    <form method="POST">
                                                        <input type="hidden" name="uid_buku_ext" value="<?= $p['uid_buku'] ?>">
                                                        <button type="submit" name="perpanjang" class="btn btn-outline-success btn-perpanjang mb-1">
                                                            <i class="bi bi-plus-circle me-1"></i> Perpanjang +3 Hari
                                                        </button>
                                                    </form>
                                                    
                                                    <?php if ($p['sisa'] <= 2): ?>
                                                        <span class="badge-status" style="background: #fef9c3; color: #92400e;">H-<?= $p['sisa'] ?></span>
                                                    <?php else: ?>
                                                        <span class="badge-status" style="background: #dcfce7; color: #166534;">AMAN</span>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="card virtual-card p-4 shadow-sm h-100">
                    <div class="d-flex justify-content-between align-items-start mb-4">
                        <i class="bi bi-broadcast fs-2 opacity-50"></i>
                        <span class="small fw-bold">KARTU DIGITAL</span>
                    </div>
                    <div class="text-center my-3">
                        <div class="bg-white text-dark d-inline-block p-2 px-4 rounded-3 fw-bold fs-4 mb-2 shadow-sm">
                            <?= htmlspecialchars($uid) ?>
                        </div>
                        <div class="text-uppercase fw-bold letter-spacing-1"><?= htmlspecialchars($nama) ?></div>
                        <div class="opacity-75 small">Mahasiswa Ganesha</div>
                    </div>
                    <div class="mt-4 pt-3 border-top border-white border-opacity-25 small opacity-75">
                        Gunakan ID digital ini jika kartu RFID fisik Anda bermasalah saat scan.
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if ($totalDendaBerjalan > 0): ?>
    <script>
        Swal.fire({
            title: 'Peringatan Denda!',
            text: 'Kamu memiliki denda berjalan sebesar Rp <?= number_format($totalDendaBerjalan,0,',','.') ?>. Harap segera kembalikan buku ke perpustakaan.',
            icon: 'warning',
            confirmButtonColor: '#7C9473',
            confirmButtonText: 'Saya Mengerti'
        });
    </script>
    <?php endif; ?>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>