<?php
require 'auth_check.php';
require 'koneksi.php';

if (empty($_SESSION['mhs_login'])) {
    header("Location: login.php");
    exit;
}

// 1. TANGKAP INPUT FILTER & SORTING
$search = mysqli_real_escape_string($conn, $_GET['search'] ?? '');
$filter = $_GET['filter'] ?? 'all'; 
$sort   = $_GET['sort'] ?? 'terbaru'; 

// 2. LOGIKA QUERY DINAMIS
// Menggunakan uid_buku karena id_buku tidak ditemukan di tabel Anda
$sql = "SELECT b.*, 
        (SELECT COUNT(*) FROM transaksi t WHERE t.uid_buku = b.uid_buku AND t.aksi = 'PINJAM') as total_dipinjam,
        (SELECT aksi FROM transaksi t WHERE t.uid_buku = b.uid_buku ORDER BY timestamp DESC LIMIT 1) as status_akhir
        FROM buku b WHERE (b.judul LIKE '%$search%' OR b.pengarang LIKE '%$search%')";

// Filter Status
if ($filter == 'tersedia') {
    $sql .= " HAVING (status_akhir = 'KEMBALI' OR status_akhir IS NULL)";
} elseif ($filter == 'dipinjam') {
    $sql .= " HAVING status_akhir = 'PINJAM'";
}

// Perbaikan Order Clause (Menggunakan uid_buku)
if ($sort == 'populer') {
    $sql .= " ORDER BY total_dipinjam DESC";
} elseif ($sort == 'terlama') {
    $sql .= " ORDER BY b.uid_buku ASC"; 
} else {
    $sql .= " ORDER BY b.uid_buku DESC"; 
}

$result = mysqli_query($conn, $sql);
?>
<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Katalog Koleksi | Pustaka Ganesha</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        :root { --pastel-bg: #FDF6F0; --sage: #7C9473; }
        body { font-family: 'Inter', sans-serif; background-color: var(--pastel-bg); margin: 0; padding: 0; }
        .app-container { max-width: 1200px; margin: 0 auto; padding: 2rem 15px; }
        .card-custom { background: #fff; border: none; border-radius: 20px; box-shadow: 0 4px 15px rgba(0,0,0,0.02); padding: 25px; }
        .form-select, .form-control { border-radius: 12px; border: 1px solid #f0f0f0; background: #fafafa; }
        .btn-sage { background: var(--sage); color: white; border: none; border-radius: 12px; font-weight: 700; padding: 10px 20px; }
        .badge-populer { background: #fef9c3; color: #92400e; font-size: 10px; padding: 4px 10px; border-radius: 50px; font-weight: 700; }
        .badge-tersedia { background: #dcfce7; color: #166534; font-size: 11px; padding: 6px 12px; border-radius: 50px; font-weight: 700; }
        .badge-dipinjam { background: #fee2e2; color: #991b1b; font-size: 11px; padding: 6px 12px; border-radius: 50px; font-weight: 700; }
    </style>
</head>
<body>
    <?php include 'navbar_mhs.php'; ?>

    <div class="app-container">
        <header class="mb-4">
            <h3 class="fw-extrabold m-0 text-dark">E-Katalog Pustaka</h3>
            <p class="text-muted small">Cari buku, cek status, dan lihat apa yang sedang populer.</p>
        </header>

        <div class="card-custom mb-4">
            <form method="GET" class="row g-3">
                <div class="col-md-4">
                    <label class="small fw-bold text-muted mb-1">Cari Buku</label>
                    <input type="text" name="search" class="form-control" placeholder="Judul atau pengarang..." value="<?= htmlspecialchars($search) ?>">
                </div>
                <div class="col-md-3">
                    <label class="small fw-bold text-muted mb-1">Status</label>
                    <select name="filter" class="form-select">
                        <option value="all" <?= $filter == 'all' ? 'selected' : '' ?>>Semua Status</option>
                        <option value="tersedia" <?= $filter == 'tersedia' ? 'selected' : '' ?>>Tersedia</option>
                        <option value="dipinjam" <?= $filter == 'dipinjam' ? 'selected' : '' ?>>Sedang Dipinjam</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="small fw-bold text-muted mb-1">Urutkan</label>
                    <select name="sort" class="form-select">
                        <option value="terbaru" <?= $sort == 'terbaru' ? 'selected' : '' ?>>Koleksi Terbaru</option>
                        <option value="populer" <?= $sort == 'populer' ? 'selected' : '' ?>>Paling Populer</option>
                        <option value="terlama" <?= $sort == 'terlama' ? 'selected' : '' ?>>Koleksi Terlama</option>
                    </select>
                </div>
                <div class="col-md-2 d-flex align-items-end">
                    <button type="submit" class="btn btn-sage w-100 shadow-sm">Terapkan</button>
                </div>
            </form>
        </div>

        <div class="card-custom p-0 overflow-hidden">
            <div class="table-responsive">
                <table class="table table-hover align-middle m-0">
                    <thead class="table-light">
                        <tr class="small text-muted text-uppercase">
                            <th class="ps-4 py-3">Detail Koleksi</th>
                            <th class="text-center">Tahun</th>
                            <th class="text-center">Pinjaman</th>
                            <th class="text-end pe-4">Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(mysqli_num_rows($result) == 0): ?>
                            <tr><td colspan="4" class="text-center py-5 text-muted small">Data tidak ditemukan.</td></tr>
                        <?php else: ?>
                            <?php while($b = mysqli_fetch_assoc($result)): 
                                $is_dipinjam = ($b['status_akhir'] == 'PINJAM');
                            ?>
                            <tr>
                                <td class="ps-4">
                                    <div class="fw-bold text-dark small mb-1"><?= htmlspecialchars($b['judul']) ?></div>
                                    <div class="text-muted" style="font-size: 11px;"><i class="bi bi-person me-1"></i><?= htmlspecialchars($b['pengarang']) ?></div>
                                </td>
                                <td class="text-center small"><?= htmlspecialchars($b['tahun'] ?? '-') ?></td>
                                <td class="text-center">
                                    <span class="badge-populer"><i class="bi bi-fire me-1"></i><?= $b['total_dipinjam'] ?>x</span>
                                </td>
                                <td class="text-end pe-4">
                                    <?php if ($is_dipinjam): ?>
                                        <span class="badge-dipinjam">DIPINJAM</span>
                                    <?php else: ?>
                                        <span class="badge-tersedia">TERSEDIA</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <?php endwhile; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>