<?php
require 'auth_check.php';
require 'koneksi.php';

// Ambil data mahasiswa + agregat transaksi
$sql = "SELECT m.uid_mhs, m.nim, m.nama, m.prodi, m.no_hp,
        COALESCE(SUM(CASE WHEN t.aksi='PINJAM' THEN 1 ELSE 0 END),0) AS total_pinjam,
        COALESCE(SUM(t.denda),0) AS total_denda,
        MAX(t.timestamp) as terakhir_aktif
        FROM mahasiswa m
        LEFT JOIN transaksi t ON m.uid_mhs = t.uid_mhs
        WHERE m.is_deleted = 0 
        GROUP BY m.uid_mhs, m.nim, m.nama, m.prodi, m.no_hp
        ORDER BY m.nim ASC";
$res  = mysqli_query($conn, $sql);
$rows = [];
while ($r = mysqli_fetch_assoc($res)) {
    $rows[] = $r;
}

$prodiList = [];
$rp = mysqli_query($conn, "SELECT DISTINCT prodi FROM mahasiswa ORDER BY prodi");
while ($p = mysqli_fetch_assoc($rp)) {
    if ($p['prodi']) $prodiList[] = $p['prodi'];
}
?>
<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard Admin | <?= $s['nama_perpus'] ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        :root { --pastel-bg: #FDF6F0; --sage: #7C9473; }
        body { font-family: 'Inter', sans-serif; background-color: var(--pastel-bg); margin: 0; }
        .app-container { max-width: 1200px; margin: 0 auto; padding: 2rem 15px; }
        .stat-card { background: #fff; border-radius: 20px; padding: 25px; box-shadow: 0 4px 15px rgba(0,0,0,0.02); border: none; }
        .chart-card { background: #fff; border-radius: 25px; padding: 30px; box-shadow: 0 4px 15px rgba(0,0,0,0.02); border: none; height: 100%; }
        .mhs-item { background: #f9fbfa; border-radius: 12px; padding: 10px; margin-bottom: 8px; border-left: 3px solid var(--sage); }
        .badge-online { font-size: 0.6rem; background: #dcfce7; color: #166534; border: 1px solid #166534; }
    </style>
</head>
<body>
<?php include 'navbar_admin.php'; ?>

<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold m-0">Data Mahasiswa</h4>
            <p class="text-muted small">Kelola keanggotaan dan pantau denda mahasiswa.</p>
        </div>
        <a href="mhs_tambah.php" class="btn btn-pastel-primary px-4 shadow-sm">
            <i class="bi bi-plus-lg me-2"></i>Tambah Mahasiswa
        </a>
    </div>

    <div class="card-custom mb-4">
        <div class="row g-3">
            <div class="col-md-4">
                <label class="small fw-bold text-muted mb-1">Cari Nama / NIM</label>
                <div class="input-group">
                    <span class="input-group-text bg-light border-0"><i class="bi bi-search"></i></span>
                    <input id="searchMhs" type="text" class="form-control bg-light border-0" placeholder="Ketik NIM atau nama...">
                </div>
            </div>
            <div class="col-md-4">
                <label class="small fw-bold text-muted mb-1">Program Studi</label>
                <select id="filterProdi" class="form-select bg-light border-0">
                    <option value="">Semua Prodi</option>
                    <?php foreach ($prodiList as $prodi): ?>
                        <option value="<?= strtolower($prodi); ?>"><?= $prodi; ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class="col-md-4">
                <label class="small fw-bold text-muted mb-1">Urutkan Berdasarkan</label>
                <select id="sortMhs" class="form-select bg-light border-0">
                    <option value="nim_asc">NIM (Terkecil)</option>
                    <option value="nama_asc">Nama (A-Z)</option>
                    <option value="pinjam_desc">Peminjaman Terbanyak</option>
                    <option value="denda_desc">Denda Terbesar</option>
                    <option value="aktif_desc">Paling Baru Aktif</option>
                </select>
            </div>
        </div>
    </div>

    <div class="card-custom overflow-hidden p-0">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0" id="tabelMhs">
                <thead class="bg-light">
                    <tr>
                        <th class="ps-4">NIM</th>
                        <th>Mahasiswa</th>
                        <th>Prodi</th>
                        <th class="text-center">Pinjam</th>
                        <th class="text-end">Total Denda</th>
                        <th class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($rows as $r): ?>
                    <tr 
                        data-nim="<?= $r['nim']; ?>" 
                        data-nama="<?= strtolower($r['nama']); ?>" 
                        data-prodi="<?= strtolower($r['prodi']); ?>" 
                        data-pinjam="<?= $r['total_pinjam']; ?>" 
                        data-denda="<?= $r['total_denda']; ?>"
                        data-aktif="<?= strtotime($r['terakhir_aktif'] ?? '1970-01-01'); ?>"
                    >
                        <td class="ps-4 fw-bold text-muted"><?= $r['nim']; ?></td>
                        <td>
                            <div class="fw-bold"><?= $r['nama']; ?></div>
                            <div class="small text-muted"><?= $r['no_hp']; ?></div>
                        </td>
                        <td><span class="badge bg-light text-dark"><?= $r['prodi']; ?></span></td>
                        <td class="text-center fw-bold text-primary"><?= $r['total_pinjam']; ?></td>
                        <td class="text-end fw-bold <?= $r['total_denda'] > 0 ? 'text-danger' : 'text-muted' ?>">
                            Rp <?= number_format($r['total_denda'],0,',','.'); ?>
                        </td>
                        <td class="text-center">
                            <div class="btn-group">
                                <a class="btn btn-sm btn-outline-secondary border-0" href="mhs_edit.php?uid=<?= $r['uid_mhs']; ?>"><i class="bi bi-pencil-square"></i></a>
                                <a class="btn btn-sm btn-outline-danger border-0" href="mhs_hapus.php?uid=<?= $r['uid_mhs']; ?>" onclick="return confirm('Hapus mahasiswa?')"><i class="bi bi-trash"></i></a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
const searchMhs = document.getElementById('searchMhs');
const filterProdi = document.getElementById('filterProdi');
const sortMhs = document.getElementById('sortMhs');
const tabelMhs = document.getElementById('tabelMhs');

function applyFilter() {
    const q = searchMhs.value.toLowerCase();
    const prodi = filterProdi.value;
    const mode = sortMhs.value;
    const tbody = tabelMhs.querySelector('tbody');
    const rows = Array.from(tbody.querySelectorAll('tr'));

    rows.forEach(tr => {
        const text = tr.innerText.toLowerCase();
        const trProdi = tr.dataset.prodi;
        tr.style.display = (text.includes(q) && (prodi === '' || trProdi === prodi)) ? '' : 'none';
    });

    const visibleRows = rows.filter(tr => tr.style.display !== 'none');
    visibleRows.sort((a,b) => {
        if(mode === 'nim_asc') return a.dataset.nim.localeCompare(b.dataset.nim);
        if(mode === 'nama_asc') return a.dataset.nama.localeCompare(b.dataset.nama);
        if(mode === 'pinjam_desc') return b.dataset.pinjam - a.dataset.pinjam;
        if(mode === 'denda_desc') return b.dataset.denda - a.dataset.denda;
        if(mode === 'aktif_desc') return b.dataset.aktif - a.dataset.aktif;
    });
    visibleRows.forEach(tr => tbody.appendChild(tr));
}

[searchMhs, filterProdi, sortMhs].forEach(el => el.addEventListener('change', applyFilter));
searchMhs.addEventListener('input', applyFilter);
</script>
</body>
</html>