<?php
session_start();
require 'koneksi.php';

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nim = trim($_POST['nim'] ?? '');

    if ($nim === '') {
        $error = 'NIM wajib diisi.';
    } else {
        $nimEsc = mysqli_real_escape_string($conn, $nim);

        // Ambil uid_mhs berdasarkan NIM
        $q = mysqli_query($conn, "SELECT uid_mhs FROM mahasiswa WHERE nim='$nimEsc' LIMIT 1");

        if (mysqli_num_rows($q) !== 1) {
            $error = 'NIM tidak terdaftar dalam sistem.';
        } else {
            $m = mysqli_fetch_assoc($q);
            $uid = $m['uid_mhs'];

            // Cek apakah ada permintaan yang masih 'pending'
            $cek = mysqli_query($conn, "SELECT id FROM password_requests WHERE uid_mhs='$uid' AND status='pending'");

            if (mysqli_num_rows($cek) > 0) {
                $error = 'Permintaan Anda sedang diproses oleh admin. Mohon tunggu.';
            } else {
                // Generate Password Sementara
                $plainPass = substr(str_shuffle('ABCDEFGHJKLMNPQRSTUVWXYZ23456789'), 0, 8);
                $hashPass  = password_hash($plainPass, PASSWORD_DEFAULT);

                // Insert ke tabel password_requests
                $insert = mysqli_query($conn, "INSERT INTO password_requests (uid_mhs, password_baru, jenis, status) 
                                               VALUES ('$uid', '$hashPass', 'reset', 'pending')");

                if($insert) {
                    $success = "Permintaan berhasil dikirim!<br>
                    Password sementara Anda: <br><span class='fs-4 fw-bold text-dark'>$plainPass</span><br>
                    <small>Catat password ini. Akun akan aktif setelah disetujui Admin.</small>";
                } else {
                    $error = "Terjadi kesalahan sistem.";
                }
            }
        }
    }
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password | Pustaka Ganesha</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        :root {
            --pastel-bg: #FDF6F0; /* Cream */
            --pastel-primary: #A8DADC; /* Pastel Blue */
            --pastel-accent: #7C9473; /* Sage Green */
            --pastel-danger: #FFB7B2; /* Pastel Red/Pink */
            --pastel-success: #C1E1C1; /* Pastel Green Success */
        }
        body {
            background-color: var(--pastel-bg);
            font-family: 'Inter', sans-serif;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0;
        }
        .reset-card {
            background: #ffffff;
            border: none;
            border-radius: 25px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.05);
            width: 100%;
            max-width: 450px;
            overflow: hidden;
        }
        .reset-header {
            background: var(--pastel-accent);
            color: white;
            padding: 2.5rem 1rem;
            text-align: center;
        }
        .reset-body { padding: 2.5rem; }
        .form-control {
            border-radius: 12px;
            padding: 0.75rem 1rem;
            border: 1px solid #E0E0E0;
            background: #F9FBFB;
        }
        .form-control:focus {
            box-shadow: 0 0 0 0.25rem rgba(124, 148, 115, 0.2);
            border-color: var(--pastel-accent);
        }
        .btn-pastel {
            background-color: var(--pastel-accent);
            color: white;
            border-radius: 12px;
            padding: 0.8rem;
            font-weight: 600;
            border: none;
            transition: 0.3s;
        }
        .btn-pastel:hover {
            background-color: #6A7F62;
            color: white;
            transform: translateY(-1px);
        }
        .alert-pastel-success {
            background-color: var(--pastel-success);
            color: #2D4F2D;
            border: none;
            border-radius: 15px;
        }
        .alert-pastel-danger {
            background-color: var(--pastel-danger);
            color: #6D4441;
            border: none;
            border-radius: 15px;
        }
    </style>
</head>
<body>

<div class="reset-card">
    <div class="reset-header">
        <i class="bi bi-shield-lock-fill fs-1"></i>
        <h4 class="mt-2 mb-0 fw-bold">Pemulihan Akun</h4>
        <small class="opacity-75">Lupa password akun mahasiswa Anda?</small>
    </div>

    <div class="reset-body">
        <?php if($error): ?>
            <div class="alert alert-pastel-danger small d-flex align-items-center mb-4">
                <i class="bi bi-exclamation-triangle-fill me-2"></i>
                <div><?= $error ?></div>
            </div>
        <?php endif; ?>

        <?php if($success): ?>
            <div class="alert alert-pastel-success d-flex align-items-center mb-4">
                <i class="bi bi-check-circle-fill me-3 fs-4"></i>
                <div><?= $success ?></div>
            </div>
        <?php endif; ?>

        <form method="POST">
            <div class="mb-4">
                <label class="form-label small fw-bold text-muted">Nomor Induk Mahasiswa (NIM)</label>
                <div class="input-group">
                    <span class="input-group-text bg-light border-end-0" style="border-radius: 12px 0 0 12px;"><i class="bi bi-person-badge"></i></span>
                    <input type="text" name="nim" class="form-control" placeholder="Masukkan NIM" style="border-radius: 0 12px 12px 0;" required>
                </div>
                <div class="form-text mt-2 small text-muted">
                    Sistem akan mengirim permintaan reset ke Admin.
                </div>
            </div>

            <button type="submit" class="btn btn-pastel w-100 mb-3 shadow-sm">
                Ajukan Reset Password
            </button>

            <div class="text-center mt-3">
                <a href="login.php" class="text-decoration-none small text-muted">
                    <i class="bi bi-arrow-left me-1"></i> Kembali ke Login
                </a>
            </div>
        </form>
    </div>
</div>

</body>
</html>