<?php
session_start();
require 'koneksi.php';

// Redirect jika sudah login
if (isset($_SESSION['admin_login'])) { header("Location: dashboard.php"); exit; }
if (isset($_SESSION['mhs_login'])) { header("Location: mhs_dashboard.php"); exit; }

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $u = mysqli_real_escape_string($conn, trim($_POST['username']));
    $p = trim($_POST['password']);

    // 1. Cek Admin
    $q_admin = mysqli_query($conn, "SELECT * FROM admin WHERE username='$u' AND password=MD5('$p')");
    if (mysqli_num_rows($q_admin) === 1) {
        $_SESSION['admin_login'] = true;
        header("Location: dashboard.php");
        exit;
    }

    // 2. Cek Mahasiswa
    $q_mhs = mysqli_query($conn, "SELECT * FROM mahasiswa WHERE nim='$u' LIMIT 1");
    if (mysqli_num_rows($q_mhs) === 1) {
        $m = mysqli_fetch_assoc($q_mhs);
        if (password_verify($p, $m['password'])) {
            $_SESSION['mhs_login'] = true;
            $_SESSION['mhs_uid']   = $m['uid_mhs'];
            $_SESSION['mhs_nama']  = $m['nama'];
            header("Location: mhs_dashboard.php");
            exit;
        }
    }
    $error = "Username/NIM atau Password salah!";
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login | Pustaka Ganesha</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            --pastel-bg: #FDF6F0;    /* Cream background */
            --sage-primary: #7C9473; /* Sage Green (Sama dengan Dashboard) */
            --sage-light: #F1F8F6;   /* Light Sage */
        }
        body {
            background-color: var(--pastel-bg);
            font-family: 'Inter', sans-serif;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0;
        }
        .login-card {
            background: #ffffff;
            border: none;
            border-radius: 30px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.03);
            width: 100%;
            max-width: 400px;
            overflow: hidden;
        }
        .login-header {
            background: var(--sage-primary); /* Header sekarang Hijau Sage */
            color: white;
            padding: 3rem 1rem;
            text-align: center;
        }
        .login-body { padding: 2.5rem; }
        .form-control {
            border-radius: 15px;
            padding: 0.8rem 1.2rem;
            border: 1px solid #E9ECEF;
            background: #F9FBFB;
        }
        .form-control:focus {
            box-shadow: 0 0 0 0.25rem rgba(124, 148, 115, 0.2);
            border-color: var(--sage-primary);
        }
        .btn-sage {
            background-color: var(--sage-primary);
            color: white;
            border-radius: 15px;
            padding: 0.9rem;
            font-weight: 700;
            border: none;
            transition: 0.3s;
        }
        .btn-sage:hover {
            background-color: #6A7F62;
            color: white;
            transform: translateY(-2px);
        }
        .input-group-text {
            background: #F9FBFB;
            border-radius: 15px;
            border-color: #E9ECEF;
        }
        .forgot-link {
            font-size: 0.85rem;
            text-decoration: none;
            color: #9BBAB9;
            font-weight: 600;
        }
        .forgot-link:hover { color: var(--sage-primary); }
    </style>
</head>
<body>

<div class="login-card">
    <div class="login-header">
        <i class="bi bi-book-half fs-1"></i>
        <h3 class="mt-3 mb-0 fw-bold">Pustaka Ganesha</h3>
        <p class="opacity-75 small mb-0">RFID Library Access</p>
    </div>

    <div class="login-body">
        <?php if($error): ?>
            <div class="alert border-0 small d-flex align-items-center mb-4" style="background: #FFB7B2; color: #6D4441; border-radius: 12px;">
                <i class="bi bi-exclamation-circle-fill me-2"></i>
                <div><?= $error ?></div>
            </div>
        <?php endif; ?>

        <form method="POST">
            <div class="mb-3">
                <label class="form-label small fw-bold text-muted">ID / NIM</label>
                <div class="input-group">
                    <span class="input-group-text border-end-0"><i class="bi bi-person text-muted"></i></span>
                    <input type="text" class="form-control border-start-0" name="username" placeholder="Masukkan NIM" required autofocus>
                </div>
            </div>

            <div class="mb-2">
                <label class="form-label small fw-bold text-muted">Password</label>
                <div class="input-group">
                    <span class="input-group-text border-end-0"><i class="bi bi-lock text-muted"></i></span>
                    <input type="password" id="pw" name="password" class="form-control border-start-0 border-end-0" placeholder="••••••••" required>
                    <span class="input-group-text border-start-0" onclick="togglePassword()">
                        <i class="bi bi-eye-fill text-muted" id="toggleIcon"></i>
                    </span>
                </div>
            </div>

            <div class="text-end mb-4">
                <a href="lupa_password.php" class="forgot-link">Lupa password?</a>
            </div>

            <button type="submit" class="btn btn-sage w-100 mb-4 shadow-sm">
                Masuk ke Sistem
            </button>

            <div class="text-center border-top pt-3">
                <a href="home.php" class="text-decoration-none small text-muted fw-semibold">
                    <i class="bi bi-house-door me-1"></i> Beranda
                </a>
            </div>
        </form>
    </div>
</div>

<script>
    function togglePassword() {
        const pw = document.getElementById('pw');
        const icon = document.getElementById('toggleIcon');
        if (pw.type === 'password') {
            pw.type = 'text';
            icon.classList.replace('bi-eye-fill', 'bi-eye-slash-fill');
        } else {
            pw.type = 'password';
            icon.classList.replace('bi-eye-slash-fill', 'bi-eye-fill');
        }
    }
</script>
</body>
</html>