<?php
require 'auth_check.php';
require 'koneksi.php';

if (empty($_SESSION['admin_login'])) {
    header("Location: login.php");
    exit;
}

// 1. TANGKAP FILTER
$dari    = $_GET['dari']   ?? date('Y-m-d', strtotime('-30 days'));
$sampai  = $_GET['sampai'] ?? date('Y-m-d');
$status_f = $_GET['status_f'] ?? 'semua'; 
$search  = mysqli_real_escape_string($conn, $_GET['search'] ?? '');
$sort    = $_GET['sort']   ?? 'terbaru';

$order = ($sort == 'terlama') ? "p.timestamp ASC" : "p.timestamp DESC";

// 2. QUERY DINAMIS
// Menambahkan pengecekan durasi dan join yang lebih presisi
$sql = "SELECT p.timestamp AS ts_pinjam, p.durasi_hari, p.denda, m.nim, m.nama, b.judul,
               k.timestamp AS ts_kembali 
        FROM transaksi p
        JOIN mahasiswa m ON p.uid_mhs = m.uid_mhs
        JOIN buku b ON p.uid_buku = b.uid_buku
        LEFT JOIN transaksi k ON k.uid_mhs = p.uid_mhs AND k.uid_buku = p.uid_buku 
             AND k.aksi = 'KEMBALI' AND k.timestamp > p.timestamp
        WHERE p.aksi = 'PINJAM' 
        AND (m.nama LIKE '%$search%' OR m.nim LIKE '%$search%' OR b.judul LIKE '%$search%')
        AND p.timestamp BETWEEN '$dari 00:00:00' AND '$sampai 23:59:59'";

if ($status_f == 'selesai') {
    $sql .= " AND k.timestamp IS NOT NULL";
} elseif ($status_f == 'aktif') {
    $sql .= " AND k.timestamp IS NULL";
}

$sql .= " ORDER BY $order";
$res = mysqli_query($conn, $sql);
$rows = [];

// Fungsi Nama Hari Indonesia
function getHari($date) {
    $days = ['Minggu', 'Senin', 'Selasa', 'Rabu', 'Kamis', 'Jumat', 'Sabtu'];
    return $days[date('w', strtotime($date))];
}

while ($r = mysqli_fetch_assoc($res)) {
    $dtPinjam = new DateTime($r['ts_pinjam']);
    $durasi_jatah = (int)($r['durasi_hari'] ?? 7);
    $dtJatuh = (clone $dtPinjam)->modify("+" . $durasi_jatah . " day");
    $adaKembali = !empty($r['ts_kembali']);
    
    // HITUNG LAMA PEMINJAMAN (DURASI AKTUAL)
    $dtAkhir = $adaKembali ? new DateTime($r['ts_kembali']) : new DateTime();
    $diff = $dtPinjam->diff($dtAkhir);
    
    // Format: X Hari Y Jam Z Menit
    $r['durasi_aktual'] = $diff->format('%a Hari, %h Jam, %i Menit');

    if ($adaKembali) {
        $dtKembali = new DateTime($r['ts_kembali']);
        $st = ($dtKembali <= $dtJatuh) ? ['Selesai', 'bg-success'] : ['Terlambat', 'bg-danger'];
    } else {
        $st = (new DateTime() <= $dtJatuh) ? ['Aktif', 'bg-primary'] : ['Melebihi Batas', 'bg-warning text-dark'];
    }

    $r['status_text'] = $st[0];
    $r['status_class'] = $st[1];
    $r['jatuh_tempo'] = $dtJatuh->format('d/m/Y');
    $rows[] = $r;
}
?>
<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Laporan Transaksi | <?= $s['nama_perpus'] ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <style>
        :root { --pastel-bg: #FDF6F0; --sage: #7C9473; }
        body { font-family: 'Inter', sans-serif; background-color: var(--pastel-bg); }
        .app-container { max-width: 1400px; margin: 0 auto; padding: 2rem 15px; }
        .card-custom { background: #fff; border-radius: 15px; box-shadow: 0 4px 15px rgba(0,0,0,0.05); border: none; padding: 20px; }
        .btn-sage { background: var(--sage); color: white; border: none; }
        .btn-sage:hover { background: #6a7f62; color: white; }
        .time-badge { font-size: 0.75rem; background: #f1f5f9; color: #475569; padding: 2px 8px; border-radius: 5px; display: inline-block; margin-top: 4px; }
        .table-responsive { border-radius: 15px; }
    </style>
</head>
<body>
    <?php include 'navbar_admin.php'; ?>
    
    <div class="app-container">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h3 class="fw-bold m-0 text-dark">Laporan Transaksi</h3>
            <a href="admin_cetak.php?<?= http_build_query($_GET) ?>" target="_blank" class="btn btn-outline-dark rounded-pill px-4 fw-bold">
                <i class="bi bi-printer me-2"></i>Cetak Laporan
            </a>
        </div>

        <div class="card-custom mb-4">
            <form method="GET" class="row g-3 align-items-end">
                <div class="col-md-2">
                    <label class="small fw-bold mb-1">Dari</label>
                    <input type="date" name="dari" class="form-control" value="<?= $dari ?>">
                </div>
                <div class="col-md-2">
                    <label class="small fw-bold mb-1">Sampai</label>
                    <input type="date" name="sampai" class="form-control" value="<?= $sampai ?>">
                </div>
                <div class="col-md-2">
                    <label class="small fw-bold mb-1">Status</label>
                    <select name="status_f" class="form-select">
                        <option value="semua" <?= $status_f=='semua'?'selected':'' ?>>Semua</option>
                        <option value="aktif" <?= $status_f=='aktif'?'selected':'' ?>>Sedang Dipinjam</option>
                        <option value="selesai" <?= $status_f=='selesai'?'selected':'' ?>>Sudah Kembali</option>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="small fw-bold mb-1">Cari Data</label>
                    <input type="text" name="search" class="form-control" placeholder="Nama/NIM/Judul Buku..." value="<?= $search ?>">
                </div>
                <div class="col-md-1">
                    <label class="small fw-bold mb-1">Urutan</label>
                    <select name="sort" class="form-select">
                        <option value="terbaru" <?= $sort=='terbaru'?'selected':'' ?>>Terbaru</option>
                        <option value="terlama" <?= $sort=='terlama'?'selected':'' ?>>Terlama</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-sage w-100 py-2 fw-bold">Muat Data</button>
                </div>
            </form>
        </div>

        <div class="card-custom p-0 overflow-hidden">
            <div class="table-responsive">
                <table class="table table-hover align-middle m-0">
                    <thead class="table-light">
                        <tr class="small text-muted text-uppercase">
                            <th class="ps-4">Waktu Pinjam</th>
                            <th>Mahasiswa</th>
                            <th>Buku & Batas</th>
                            <th class="text-center">Lama Pinjam</th>
                            <th>Waktu Kembali</th>
                            <th class="text-center">Status</th>
                            <th class="text-end pe-4">Denda</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(empty($rows)): ?>
                            <tr><td colspan="7" class="text-center py-5 text-muted">Data tidak ditemukan.</td></tr>
                        <?php endif; ?>

                        <?php foreach ($rows as $r): ?>
                        <tr class="small">
                            <td class="ps-4">
                                <div class="fw-bold"><?= getHari($r['ts_pinjam']) ?></div>
                                <div><?= date('d/m/y', strtotime($r['ts_pinjam'])) ?></div>
                                <div class="time-badge"><i class="bi bi-clock me-1"></i><?= date('H:i', strtotime($r['ts_pinjam'])) ?></div>
                            </td>
                            <td>
                                <div class="fw-bold text-uppercase"><?= htmlspecialchars($r['nama']) ?></div>
                                <div class="text-muted"><?= $r['nim'] ?></div>
                            </td>
                            <td>
                                <div class="fw-bold"><?= htmlspecialchars($r['judul']) ?></div>
                                <div class="text-danger" style="font-size: 0.7rem;">Batas: <?= $r['jatuh_tempo'] ?></div>
                            </td>
                            <td class="text-center">
                                <span class="badge bg-light text-dark border fw-normal">
                                    <i class="bi bi-hourglass-split me-1 text-primary"></i><?= $r['durasi_aktual'] ?>
                                </span>
                            </td>
                            <td>
                                <?php if($r['ts_kembali']): ?>
                                    <div class="fw-bold"><?= getHari($r['ts_kembali']) ?></div>
                                    <div><?= date('d/m/y', strtotime($r['ts_kembali'])) ?></div>
                                    <div class="time-badge" style="background: #dcfce7; color: #166534;">
                                        <i class="bi bi-check-circle me-1"></i><?= date('H:i', strtotime($r['ts_kembali'])) ?>
                                    </div>
                                <?php else: ?>
                                    <span class="text-muted italic">Belum Kembali</span>
                                <?php endif; ?>
                            </td>
                            <td class="text-center">
                                <span class="badge <?= $r['status_class'] ?> rounded-pill" style="font-size: 0.7rem;">
                                    <?= $r['status_text'] ?>
                                </span>
                            </td>
                            <td class="text-end pe-4 fw-bold <?= $r['denda'] > 0 ? 'text-danger' : 'text-muted' ?>">
                                Rp <?= number_format($r['denda'],0,',','.') ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</body>
</html>