<?php
session_start();

// Redirect jika sudah login
if (isset($_SESSION['admin_login'])) {
    header("Location: dashboard.php");
    exit;
}
if (isset($_SESSION['mhs_login'])) {
    header("Location: mhs_dashboard.php");
    exit;
}
?>
<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Pustaka Ganesha | Sistem Perpustakaan RFID</title>
    
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <style>
        :root {
            --pastel-bg: #FDF6F0;
            --pastel-sage: #7C9473;
            --pastel-blue: #A8DADC;
            --pastel-pink: #FFB7B2;
        }

        body {
            font-family: 'Inter', sans-serif;
            background-color: var(--pastel-bg);
            color: #4b5563;
        }

        .hero {
            padding: 120px 0 80px;
            background: linear-gradient(180deg, #fff 0%, var(--pastel-bg) 100%);
        }

        .btn-sage {
            background-color: var(--pastel-sage);
            color: white;
            border-radius: 12px;
            padding: 12px 30px;
            font-weight: 700;
            border: none;
            transition: 0.3s;
        }

        .btn-sage:hover {
            background-color: #6A7F62;
            color: white;
            transform: translateY(-3px);
            box-shadow: 0 10px 20px rgba(124, 148, 115, 0.2);
        }

        .feature-card {
            background: #ffffff;
            border: none;
            border-radius: 25px;
            padding: 35px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.03);
            transition: 0.3s;
            height: 100%;
        }

        .feature-card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 40px rgba(0,0,0,0.06);
        }

        .icon-box {
            width: 60px;
            height: 60px;
            border-radius: 18px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 28px;
            margin: 0 auto 20px;
        }

        .step-number {
            font-weight: 800;
            color: var(--pastel-sage);
            font-size: 1.5rem;
            margin-bottom: 10px;
            display: block;
        }

        footer {
            background: #fff;
            padding: 30px 0;
            margin-top: 50px;
        }
    </style>
</head>
<body>

<section class="hero text-center">
    <div class="container">
        <div class="mb-4">
            <i class="bi bi-book-half text-sage" style="font-size: 4rem; color: var(--pastel-sage);"></i>
        </div>
        <h1 class="display-4 fw-extrabold mb-3 text-dark">Pustaka Ganesha</h1>
        <p class="lead text-muted mb-5 mx-auto" style="max-width: 600px;">
            Sistem manajemen perpustakaan modern dengan teknologi <b>RFID</b> untuk kemudahan peminjaman dan pengembalian buku secara real-time.
        </p>

        <a href="login.php" class="btn btn-sage btn-lg shadow-sm">
            <i class="bi bi-shield-lock-fill me-2"></i> Masuk ke Sistem
        </a>
    </div>
</section>

<section class="py-5">
    <div class="container">
        <div class="row g-4 justify-content-center">
            
            <div class="col-md-4">
                <div class="feature-card text-center">
                    <div class="icon-box" style="background: #f1f8f6; color: var(--pastel-sage);">
                        <i class="bi bi-broadcast"></i>
                    </div>
                    <h5 class="fw-bold text-dark">RFID Otomatis</h5>
                    <p class="small text-muted mb-0">
                        Cukup tempelkan kartu mahasiswa atau tag buku. Transaksi tercatat otomatis tanpa input manual.
                    </p>
                </div>
            </div>

            <div class="col-md-4">
                <div class="feature-card text-center">
                    <div class="icon-box" style="background: #f0f9fa; color: #457b9d;">
                        <i class="bi bi-shield-check"></i>
                    </div>
                    <h5 class="fw-bold text-dark">Keamanan Akun</h5>
                    <p class="small text-muted mb-0">
                        Keamanan data terjamin dengan enkripsi password dan sistem persetujuan admin untuk pemulihan akun.
                    </p>
                </div>
            </div>

            <div class="col-md-4">
                <div class="feature-card text-center">
                    <div class="icon-box" style="background: #fff5f5; color: #d63031;">
                        <i class="bi bi-graph-up-arrow"></i>
                    </div>
                    <h5 class="fw-bold text-dark">Real-time Monitor</h5>
                    <p class="small text-muted mb-0">
                        Admin dapat memantau ketersediaan buku dan riwayat transaksi mahasiswa secara langsung melalui dashboard.
                    </p>
                </div>
            </div>

        </div>
    </div>
</section>

<section class="py-5 bg-white shadow-sm" style="border-radius: 50px 50px 0 0;">
    <div class="container text-center">
        <h4 class="fw-bold mb-5">Cara Kerja Sistem</h4>
        <div class="row g-4">
            <div class="col-md-4">
                <span class="step-number">01</span>
                <h6 class="fw-bold">Login Akun</h6>
                <p class="small text-muted">Akses panel menggunakan NIM atau Username Admin yang terdaftar.</p>
            </div>
            <div class="col-md-4 border-start border-end">
                <span class="step-number">02</span>
                <h6 class="fw-bold">Scan RFID</h6>
                <p class="small text-muted">Gunakan alat scanner RFID untuk melakukan peminjaman atau pengembalian buku.</p>
            </div>
            <div class="col-md-4">
                <span class="step-number">03</span>
                <h6 class="fw-bold">Selesai</h6>
                <p class="small text-muted">Data akan otomatis terupdate di laporan dan status buku akan berubah.</p>
            </div>
        </div>
    </div>
</section>

<footer class="text-center">
    <div class="container">
        <p class="small text-muted mb-0">
            &copy; <?= date('Y'); ?> <b>Pustaka Ganesha</b>. Powered by RFID Technology.
        </p>
    </div>
</footer>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>