<?php
require 'koneksi.php';

// Gunakan kolom created_at sesuai gambar database Anda
$query = mysqli_query($conn, "SELECT * FROM scan_log ORDER BY id_log DESC LIMIT 5");

if (mysqli_num_rows($query) == 0) {
    echo "<div class='text-center py-3 text-muted small'>Menunggu aktivitas...</div>";
    exit;
}

while($row = mysqli_fetch_assoc($query)) {
    $warna = ($row['status'] == 'ok') ? 'text-success' : 'text-danger';
    $ikon = ($row['aksi'] == 'PINJAM') ? 'bi-arrow-up-right' : 'bi-arrow-down-left';
    $bgIcon = ($row['status'] == 'ok') ? '#f0fdf4' : '#fef2f2';
    
    echo "
    <div class='d-flex align-items-center mb-2 p-2 rounded-3 border-bottom shadow-sm' style='background: #fff;'>
        <div class='icon-box me-3' style='background: $bgIcon; width: 35px; height: 35px; border-radius: 8px; display: flex; align-items: center; justify-content: center;'>
            <i class='bi $ikon $warna'></i>
        </div>
        <div style='flex-grow: 1; overflow: hidden;'>
            <div class='fw-bold' style='font-size: 0.75rem;'>" . htmlspecialchars($row['nama'] ?: 'Unknown') . "</div>
            <div class='text-muted text-truncate' style='font-size: 0.65rem;'>" . htmlspecialchars($row['judul'] ?: $row['message']) . "</div>
        </div>
        <div class='text-end ms-2'>
            <div style='font-size: 0.6rem; color: #999;'>" . date('H:i', strtotime($row['created_at'])) . "</div>
            <span class='badge' style='font-size: 0.5rem; background: " . ($row['status'] == 'ok' ? '#dcfce7' : '#fee2e2') . "; color: " . ($row['status'] == 'ok' ? '#166534' : '#991b1b') . ";'>" 
            . $row['status'] . 
            "</span>
        </div>
    </div>";
}
?>