<?php
require 'auth_check.php';
require 'koneksi.php';

if (empty($_SESSION['admin_login'])) {
    header("Location: login.php");
    exit;
}

// 1. Ambil Data Pengaturan
$s = mysqli_fetch_assoc(mysqli_query($conn, "SELECT * FROM system_settings WHERE id = 1"));

// 2. Statistik Inventaris
$totalMhs  = mysqli_fetch_assoc(mysqli_query($conn,"SELECT COUNT(*) c FROM mahasiswa"))['c'];
$totalBuku = mysqli_fetch_assoc(mysqli_query($conn,"SELECT COUNT(*) c FROM buku"))['c'];
$sedangDipinjam = mysqli_fetch_assoc(mysqli_query($conn,"
    SELECT COUNT(*) c FROM transaksi p
    WHERE aksi='PINJAM'
    AND NOT EXISTS (
        SELECT 1 FROM transaksi k
        WHERE k.uid_mhs=p.uid_mhs AND k.uid_buku=p.uid_buku AND k.aksi='KEMBALI' AND k.timestamp>p.timestamp
    )
"))['c'];

// 3. Data Grafik 7 Hari Terakhir
$labels = []; $dataPinjam = []; $dataKembali = [];
for ($i = 6; $i >= 0; $i--) {
    $tgl = date('Y-m-d', strtotime("-$i days"));
    $labels[] = date('d M', strtotime($tgl));
    $dataPinjam[]  = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) c FROM transaksi WHERE aksi='PINJAM' AND DATE(timestamp)='$tgl'"))['c'] ?? 0;
    $dataKembali[] = mysqli_fetch_assoc(mysqli_query($conn, "SELECT COUNT(*) c FROM transaksi WHERE aksi='KEMBALI' AND DATE(timestamp)='$tgl'"))['c'] ?? 0;
}

// 4. Data Buku Populer
$bukuPopuler = mysqli_query($conn, "SELECT b.judul, COUNT(t.id_trans) as total FROM transaksi t JOIN buku b ON t.uid_buku = b.uid_buku WHERE t.aksi = 'PINJAM' GROUP BY t.uid_buku ORDER BY total DESC LIMIT 4");

// 5. Data Mahasiswa Paling Aktif
$mhsAktif = mysqli_query($conn, "
    SELECT m.nama, COUNT(t.id_trans) as jml 
    FROM transaksi t 
    JOIN mahasiswa m ON t.uid_mhs = m.uid_mhs 
    WHERE t.aksi = 'PINJAM' 
    GROUP BY t.uid_mhs 
    ORDER BY jml DESC 
    LIMIT 3
");
?>
<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard Admin | <?= $s['nama_perpus'] ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        :root { --pastel-bg: #FDF6F0; --sage: #7C9473; }
        body { font-family: 'Inter', sans-serif; background-color: var(--pastel-bg); margin: 0; }
        .app-container { max-width: 1200px; margin: 0 auto; padding: 2rem 15px; }
        .stat-card { background: #fff; border-radius: 20px; padding: 25px; box-shadow: 0 4px 15px rgba(0,0,0,0.02); border: none; }
        .chart-card { background: #fff; border-radius: 25px; padding: 30px; box-shadow: 0 4px 15px rgba(0,0,0,0.02); border: none; height: 100%; }
        .mhs-item { background: #f9fbfa; border-radius: 12px; padding: 10px; margin-bottom: 8px; border-left: 3px solid var(--sage); }
        .badge-online { font-size: 0.6rem; background: #dcfce7; color: #166534; border: 1px solid #166534; }
    </style>
</head>
<body>
    <?php include 'navbar_admin.php'; ?>

    <div class="app-container">
        <header class="mb-4">
            <h3 class="fw-extrabold m-0 text-dark">Panel Kendali Admin</h3>
            <p class="text-muted small">Ringkasan <?= $s['nama_perpus'] ?> secara real-time.</p>
        </header>

        <div class="row g-3 mb-4">
            <div class="col-md-4">
                <div class="stat-card border-start border-4 border-success">
                    <div class="text-muted small fw-bold">TOTAL BUKU</div>
                    <h2 class="fw-extrabold m-0"><?= $totalBuku ?></h2>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card border-start border-4 border-primary">
                    <div class="text-muted small fw-bold">MAHASISWA TERDAFTAR</div>
                    <h2 class="fw-extrabold m-0"><?= $totalMhs ?></h2>
                </div>
            </div>
            <div class="col-md-4">
                <div class="stat-card border-start border-4 border-warning">
                    <div class="text-muted small fw-bold">PINJAMAN AKTIF</div>
                    <h2 class="fw-extrabold m-0"><?= $sedangDipinjam ?></h2>
                </div>
            </div>
        </div>

        <div class="row g-4">
            <div class="col-lg-8">
                <div class="chart-card">
                    <h6 class="fw-bold mb-4"><i class="bi bi-graph-up-arrow me-2 text-primary"></i>Tren Transaksi (7 Hari Terakhir)</h6>
                    <div style="position: relative; height: 350px;">
                        <canvas id="loanChart"></canvas>
                    </div>
                </div>
            </div>

            <div class="col-lg-4">
                <div class="stat-card mb-4">
                    <h6 class="fw-bold mb-3 small"><i class="bi bi-star-fill text-warning me-2"></i>Buku Populer</h6>
                    <ul class="list-group list-group-flush">
                        <?php while($bp = mysqli_fetch_assoc($bukuPopuler)): ?>
                        <li class="list-group-item d-flex justify-content-between align-items-center bg-transparent px-0 border-light py-2">
                            <span class="small fw-semibold text-dark text-truncate me-2"><?= htmlspecialchars($bp['judul']) ?></span>
                            <span class="badge bg-success rounded-pill" style="font-size: 0.6rem;"><?= $bp['total'] ?>x</span>
                        </li>
                        <?php endwhile; ?>
                    </ul>
                </div>

                <div class="stat-card mb-4">
                    <h6 class="fw-bold mb-3 small"><i class="bi bi-people-fill text-primary me-2"></i>Mahasiswa Teraktif</h6>
                    <?php while($ma = mysqli_fetch_assoc($mhsAktif)): ?>
                    <div class="mhs-item d-flex justify-content-between align-items-center mb-2 p-2">
                        <span class="small fw-bold text-dark text-truncate me-2"><?= htmlspecialchars($ma['nama']) ?></span>
                        <span class="text-muted fw-bold" style="font-size: 9px;"><?= $ma['jml'] ?> Pinjaman</span>
                    </div>
                    <?php endwhile; ?>
                </div>

                <div class="stat-card">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <h6 class="fw-bold m-0 small"><i class="bi bi-broadcast text-danger me-2"></i>Live Monitoring</h6>
                        <span class="badge badge-online px-2 py-1 rounded-pill pulse">ONLINE</span>
                    </div>
                    <div id="live-scan-data" style="max-height: 180px; overflow-y: auto;">
                        <div class="text-center py-3 text-muted small">Memuat data aktivitas...</div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
    function updateLiveScan() {
        fetch('get_latest_scan.php')
            .then(response => response.text())
            .then(data => { document.getElementById('live-scan-data').innerHTML = data; });
    }
    setInterval(updateLiveScan, 2000);
    updateLiveScan();

    const ctxLoan = document.getElementById('loanChart').getContext('2d');
    new Chart(ctxLoan, {
        type: 'line',
        data: {
            labels: <?= json_encode($labels) ?>,
            datasets: [{
                label: 'Pinjam', data: <?= json_encode($dataPinjam) ?>,
                borderColor: '#7C9473', backgroundColor: 'rgba(124, 148, 115, 0.1)', fill: true, tension: 0.4
            }, {
                label: 'Kembali', data: <?= json_encode($dataKembali) ?>,
                borderColor: '#A8DADC', backgroundColor: 'rgba(168, 218, 220, 0.1)', fill: true, tension: 0.4
            }]
        },
        options: { 
            responsive: true,
            maintainAspectRatio: false,
            plugins: { legend: { position: 'bottom', labels: { usePointStyle: true, padding: 20 } } }, 
            scales: { y: { beginAtZero: true, ticks: { stepSize: 1 } } } 
        }
    });
    </script>
</body>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</html>