<?php
require 'auth_check.php';
require 'koneksi.php'; // Jalur diperbaiki

$success = ''; $error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $uid_buku = mysqli_real_escape_string($conn, $_POST['uid_buku'] ?? '');
    $judul    = mysqli_real_escape_string($conn, $_POST['judul'] ?? '');
    $pengarang= mysqli_real_escape_string($conn, $_POST['pengarang'] ?? '');
    $tahun    = intval($_POST['tahun']);
    if ($uid_buku && $judul) {
        $cek = mysqli_query($conn, "SELECT 1 FROM buku WHERE uid_buku='$uid_buku'");
        if (mysqli_num_rows($cek) > 0) { $error = 'UID Buku sudah terdaftar!'; }
        else {
            $sql = "INSERT INTO buku (uid_buku, judul, pengarang, tahun, status) VALUES ('$uid_buku', '$judul', '$pengarang', '$tahun', 'tersedia')";
            if (mysqli_query($conn, $sql)) { $success = 'Buku berhasil didaftarkan!'; } else { $error = 'Gagal menyimpan.'; }
        }
    }
}
?>
<!doctype html>
<html lang="id">
<head>
    <title>Tambah Buku</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>
<body style="background:#FDF6F0; padding-top:50px;">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <a href="buku.php" class="btn btn-outline-dark mb-3 rounded-pill btn-sm"><i class="bi bi-arrow-left"></i> Kembali ke Koleksi</a>
                <div class="card border-0 shadow-sm p-4" style="border-radius:20px;">
                    <h5 class="fw-bold mb-4">Daftarkan Buku Baru</h5>
                    <?php if($success): ?> <div class="alert alert-success border-0 small"><?= $success ?></div> <?php endif; ?>
                    <?php if($error): ?> <div class="alert alert-danger border-0 small"><?= $error ?></div> <?php endif; ?>
                    <form method="POST">
                        <div class="mb-3">
                            <label class="small fw-bold">UID Tag Buku</label>
                            <div class="input-group">
                                <input type="text" name="uid_buku" id="uid_buku" class="form-control" readonly required placeholder="Scan buku mode 'B'...">
                                <button class="btn btn-primary" type="button" onclick="ambilUid('BUKU')">Ambil UID</button>
                            </div>
                        </div>
                        <div class="mb-3"><label class="small fw-bold">Judul Buku</label><input type="text" name="judul" class="form-control" required></div>
                        <div class="mb-3"><label class="small fw-bold">Pengarang</label><input type="text" name="pengarang" class="form-control"></div>
                        <div class="mb-3"><label class="small fw-bold">Tahun Terbit</label><input type="number" name="tahun" class="form-control" value="<?= date('Y') ?>"></div>
                        <button type="submit" class="btn btn-dark w-100 py-2 mt-2" style="border-radius:10px;">Simpan Koleksi</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script>
    function ambilUid(jenis) {
        fetch('api/get_latest_uid.php?jenis=' + jenis)
            .then(res => res.json())
            .then(data => {
                if(data.status==='ok') { 
                    document.getElementById('uid_buku').value = data.uid; 
                    Swal.fire({ icon: 'success', title: 'Berhasil', text: 'UID Buku disalin', timer: 1000, showConfirmButton: false });
                } else { Swal.fire('Gagal', 'Scan buku mode B di alat dulu!', 'info'); }
            });
    }
    </script>
</body>
</html>