<?php
require 'auth_check.php';
require 'koneksi.php';

$uid = isset($_GET['uid']) ? $_GET['uid'] : '';

$q = mysqli_query($conn, "SELECT * FROM buku WHERE uid_buku='$uid'");
$buku = mysqli_fetch_assoc($q);
if (!$buku) {
    header('Location: buku.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $judul     = mysqli_real_escape_string($conn, $_POST['judul']);
    $pengarang = mysqli_real_escape_string($conn, $_POST['pengarang']);
    $tahun     = (int)$_POST['tahun'];
    $status    = mysqli_real_escape_string($conn, $_POST['status']);

    mysqli_query($conn, "UPDATE buku 
                         SET judul='$judul',
                             pengarang='$pengarang',
                             tahun=$tahun,
                             status='$status'
                         WHERE uid_buku='$uid'");

    header('Location: buku.php?msg=update_buku_ok');
    exit;
}
?>
<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <title>Edit Buku - RFID Perpustakaan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="assets/style.css" rel="stylesheet">
</head>
<body class="app-body">
<?php include 'navbar_admin.php'; ?>

<div class="container py-4">
    <div class="row justify-content-center">
        <div class="col-lg-6">

            <div class="card shadow-sm border-0 rounded-4 app-card">
                <div class="card-body p-4 p-lg-5">
                    <div class="d-flex align-items-center mb-3">
                        <div class="avatar-circle me-3">
                            <span class="avatar-text">
                                📚
                            </span>
                        </div>
                        <div>
                            <h4 class="mb-0 fw-semibold">Edit Buku</h4>
                            <small class="text-muted">UID: <?= htmlspecialchars($buku['uid_buku']); ?></small>
                        </div>
                    </div>

                    <form method="post" class="mt-3">

                        <div class="mb-3">
                            <label class="form-label">UID Buku</label>
                            <input type="text" class="form-control" 
                                   value="<?= htmlspecialchars($buku['uid_buku']); ?>" disabled>
                            <div class="form-text">UID buku mengikuti tag RFID dan tidak dapat diubah.</div>
                        </div>

                        <div class="mb-3">
                            <label for="judul" class="form-label">Judul Buku</label>
                            <input type="text" id="judul" name="judul" class="form-control"
                                   value="<?= htmlspecialchars($buku['judul']); ?>" required>
                        </div>

                        <div class="mb-3">
                            <label for="pengarang" class="form-label">Pengarang</label>
                            <input type="text" id="pengarang" name="pengarang" class="form-control"
                                   value="<?= htmlspecialchars($buku['pengarang']); ?>">
                        </div>

                        <div class="mb-3">
                            <label for="tahun" class="form-label">Tahun Terbit</label>
                            <input type="number" id="tahun" name="tahun" class="form-control"
                                   value="<?= htmlspecialchars($buku['tahun']); ?>" min="1900" max="2100">
                        </div>

                        <div class="mb-4">
                            <label for="status" class="form-label">Status Buku</label>
                            <select id="status" name="status" class="form-select">
                                <option value="tersedia" <?= $buku['status']=='tersedia'?'selected':''; ?>>Tersedia</option>
                                <option value="dipinjam" <?= $buku['status']=='dipinjam'?'selected':''; ?>>Dipinjam</option>
                            </select>
                        </div>

                        <div class="d-flex justify-content-between gap-2">
                            <a href="buku.php" class="btn btn-outline-secondary px-4">
                                ← Kembali
                            </a>
                            <button type="submit" class="btn btn-primary app-btn-primary px-4">
                                Simpan Perubahan
                            </button>
                        </div>

                    </form>
                </div>
            </div>

        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>