<?php
require 'auth_check.php';
require 'koneksi.php';

$sql = "SELECT b.uid_buku, b.judul, b.pengarang, b.tahun, b.status,
        COALESCE(SUM(CASE WHEN t.aksi='PINJAM' THEN 1 ELSE 0 END),0) AS total_dipinjam,
        COALESCE(SUM(t.denda),0) AS total_denda
        FROM buku b
        LEFT JOIN transaksi t ON b.uid_buku = t.uid_buku
        WHERE b.is_deleted = 0
        GROUP BY b.uid_buku, b.judul, b.pengarang, b.tahun, b.status
        ORDER BY b.judul ASC";
$res  = mysqli_query($conn, $sql);
$rows = [];
while ($r = mysqli_fetch_assoc($res)) {
    $rows[] = $r;
}
?>
<!doctype html>
<html lang="id">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Dashboard Admin | <?= $s['nama_perpus'] ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <style>
        :root { --pastel-bg: #FDF6F0; --sage: #7C9473; }
        body { font-family: 'Inter', sans-serif; background-color: var(--pastel-bg); margin: 0; }
        .app-container { max-width: 1200px; margin: 0 auto; padding: 2rem 15px; }
        .stat-card { background: #fff; border-radius: 20px; padding: 25px; box-shadow: 0 4px 15px rgba(0,0,0,0.02); border: none; }
        .chart-card { background: #fff; border-radius: 25px; padding: 30px; box-shadow: 0 4px 15px rgba(0,0,0,0.02); border: none; height: 100%; }
        .mhs-item { background: #f9fbfa; border-radius: 12px; padding: 10px; margin-bottom: 8px; border-left: 3px solid var(--sage); }
        .badge-online { font-size: 0.6rem; background: #dcfce7; color: #166534; border: 1px solid #166534; }
    </style>
</head>
<body>
<?php include 'navbar_admin.php'; ?>

<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h4 class="fw-bold m-0">Koleksi Buku</h4>
            <p class="text-muted small">Total judul buku: <strong><?= count($rows); ?></strong></p>
        </div>
        <a href="buku_tambah.php" class="btn btn-primary px-4 rounded-pill shadow-sm" style="background:#7C9473; border:none;">
            <i class="bi bi-plus-lg me-2"></i>Tambah Buku
        </a>
    </div>

    <div class="card-custom mb-4">
        <div class="row g-3">
            <div class="col-md-4">
                <label class="small fw-bold text-muted mb-1">Cari Buku / Pengarang</label>
                <input id="searchBuku" type="text" class="form-control bg-light border-0" placeholder="Ketik judul...">
            </div>
            <div class="col-md-4">
                <label class="small fw-bold text-muted mb-1">Status Ketersediaan</label>
                <select id="filterStatus" class="form-select bg-light border-0">
                    <option value="">Semua Status</option>
                    <option value="tersedia">Tersedia</option>
                    <option value="dipinjam">Dipinjam</option>
                </select>
            </div>
            <div class="col-md-4">
                <label class="small fw-bold text-muted mb-1">Urutkan Koleksi</label>
                <select id="sortBuku" class="form-select bg-light border-0">
                    <option value="judul_asc">Judul (A-Z)</option>
                    <option value="tahun_desc">Tahun (Terbaru)</option>
                    <option value="tahun_asc">Tahun (Terlama)</option>
                    <option value="pinjam_desc">Paling Sering Dipinjam</option>
                </select>
            </div>
        </div>
    </div>

    <div class="card-custom p-0 overflow-hidden">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0" id="tabelBuku">
                <thead class="table-light">
                    <tr>
                        <th class="ps-4">Judul & Pengarang</th>
                        <th class="text-center">Tahun</th>
                        <th class="text-center">Status</th>
                        <th class="text-center">Populer</th>
                        <th class="text-end">Denda</th>
                        <th class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($rows as $r): ?>
                    <tr 
                        data-judul="<?= strtolower($r['judul']); ?>" 
                        data-tahun="<?= $r['tahun']; ?>" 
                        data-status="<?= $r['status']; ?>" 
                        data-pinjam="<?= $r['total_dipinjam']; ?>"
                    >
                        <td class="ps-4">
                            <div class="fw-bold"><?= $r['judul']; ?></div>
                            <div class="small text-muted"><?= $r['pengarang']; ?></div>
                        </td>
                        <td class="text-center"><?= $r['tahun']; ?></td>
                        <td class="text-center">
                            <span class="badge-status-<?= $r['status']; ?>"><?= ucfirst($r['status']); ?></span>
                        </td>
                        <td class="text-center fw-bold"><?= $r['total_dipinjam']; ?>x</td>
                        <td class="text-end text-danger fw-bold">Rp <?= number_format($r['total_denda'],0,',','.'); ?></td>
                        <td class="text-center">
                            <div class="btn-group">
                                <a class="btn btn-sm btn-outline-secondary border-0" href="buku_edit.php?uid=<?= $r['uid_buku']; ?>"><i class="bi bi-pencil-square"></i></a>
                                <a class="btn btn-sm btn-outline-danger border-0" href="buku_hapus.php?uid=<?= $r['uid_buku']; ?>" onclick="return confirm('Hapus buku?')"><i class="bi bi-trash"></i></a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
function applyFilter() {
    const q = document.getElementById('searchBuku').value.toLowerCase();
    const st = document.getElementById('filterStatus').value;
    const mode = document.getElementById('sortBuku').value;
    const tbody = document.getElementById('tabelBuku').querySelector('tbody');
    const rows = Array.from(tbody.querySelectorAll('tr'));

    rows.forEach(tr => {
        const text = tr.innerText.toLowerCase();
        const trStatus = tr.dataset.status;
        tr.style.display = (text.includes(q) && (st === '' || trStatus === st)) ? '' : 'none';
    });

    const visible = rows.filter(tr => tr.style.display !== 'none');
    visible.sort((a,b) => {
        if(mode === 'judul_asc') return a.dataset.judul.localeCompare(b.dataset.judul);
        if(mode === 'tahun_desc') return b.dataset.tahun - a.dataset.tahun;
        if(mode === 'tahun_asc') return a.dataset.tahun - b.dataset.tahun;
        if(mode === 'pinjam_desc') return b.dataset.pinjam - a.dataset.pinjam;
    });
    visible.forEach(tr => tbody.appendChild(tr));
}
document.querySelectorAll('input, select').forEach(el => el.addEventListener('change', applyFilter));
document.getElementById('searchBuku').addEventListener('input', applyFilter);
</script>
</body>
</html>