<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$current = basename($_SERVER['PHP_SELF']);

/* ======================
   HALAMAN PUBLIK
====================== */
$publicPages = [
    'login.php',
    'home.php',
    'index.php',
    'lupa_password.php'
];

if (in_array($current, $publicPages)) {
    return;
}

/* ======================
   BELUM LOGIN
====================== */
if (!isset($_SESSION['admin_login']) && !isset($_SESSION['mhs_login'])) {
    header("Location: login.php");
    exit;
}

/* ======================
   BATAS AKSES ROLE
====================== */

// halaman admin
$adminPages = [
    'dashboard.php',
    'buku.php',
    'buku_tambah.php',
    'buku_edit.php',
    'buku_hapus.php',
    'mhs.php',
    'mhs_edit.php',
    'mhs_hapus.php',
    'laporan.php',
    'status_buku.php',
    'riwayat_nim.php'
];

// halaman mahasiswa
$mhsPages = [
    'mhs_dashboard.php',
    'mhs_buku.php',
    'mhs_riwayat.php',
    'mhs_profile.php'
];

// mahasiswa buka halaman admin
if (isset($_SESSION['mhs_login']) && in_array($current, $adminPages)) {
    header("Location: mhs_dashboard.php");
    exit;
}

// admin buka halaman mahasiswa
if (isset($_SESSION['admin_login']) && in_array($current, $mhsPages)) {
    header("Location: dashboard.php");
    exit;
}
