<?php
// file: api/set_durasi.php
require '../koneksi.php';
header('Content-Type: application/json; charset=utf-8');

// sama dengan di scan.php
const DENDA_PER_HARI = 1000;

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['status' => 'error', 'message' => 'Gunakan POST']);
    exit;
}

$raw  = file_get_contents('php://input');
$data = json_decode($raw, true);

$id_trans    = isset($data['id_trans'])    ? (int)$data['id_trans']    : 0;
$durasi_hari = isset($data['durasi_hari']) ? (int)$data['durasi_hari'] : 0;

if ($id_trans <= 0 || $durasi_hari <= 0 || $durasi_hari > 60) {
    echo json_encode(['status' => 'error', 'message' => 'Durasi harus 1–60 hari.']);
    exit;
}

// ambil transaksi PINJAM
$sql = "SELECT * FROM transaksi WHERE id_trans=$id_trans AND aksi='PINJAM' LIMIT 1";
$res = mysqli_query($conn, $sql);
if (!$res || mysqli_num_rows($res) === 0) {
    echo json_encode(['status' => 'error', 'message' => 'Transaksi PINJAM tidak ditemukan.']);
    exit;
}
$row = mysqli_fetch_assoc($res);

$durasi_lama   = (int)($row['durasi_hari'] ?? 7);
$perpanjang_ke = (int)($row['perpanjang_ke'] ?? 0);

// kalau durasi baru > lama → hitung sebagai perpanjangan
if ($durasi_hari > $durasi_lama) {
    $perpanjang_ke++;
}

// hitung ulang denda kalau sudah ada tgl_kembali
$denda_baru = (int)($row['denda'] ?? 0);

if (!empty($row['tgl_kembali']) && $row['tgl_kembali'] !== '0000-00-00') {
    $tgl_pinjam  = $row['tgl_pinjam'] ?: substr($row['timestamp'], 0, 10);
    $tgl_kembali = $row['tgl_kembali'];

    $dt_pinjam  = new DateTime($tgl_pinjam);
    $dt_kembali = new DateTime($tgl_kembali);

    $dt_jatuh = clone $dt_pinjam;
    $dt_jatuh->modify("+{$durasi_hari} day");

    if ($dt_kembali > $dt_jatuh) {
        $telat_hari = $dt_kembali->diff($dt_jatuh)->days;
        $denda_baru = $telat_hari * DENDA_PER_HARI;
    } else {
        $denda_baru = 0;
    }
}

// update
$sqlUpd = "
    UPDATE transaksi
    SET durasi_hari   = $durasi_hari,
        perpanjang_ke = $perpanjang_ke,
        denda         = $denda_baru
    WHERE id_trans    = $id_trans
";
if (!mysqli_query($conn, $sqlUpd)) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Gagal update durasi: ' . mysqli_error($conn)
    ]);
    exit;
}

echo json_encode([
    'status'  => 'ok',
    'message' => 'Durasi peminjaman berhasil diperbarui.',
    'data'    => [
        'id_trans'      => $id_trans,
        'durasi_hari'   => $durasi_hari,
        'perpanjang_ke' => $perpanjang_ke,
        'denda'         => $denda_baru
    ]
]);