<?php
require '../koneksi.php';
header('Content-Type: application/json');

$data = json_decode(file_get_contents('php://input'), true);
$uid = mysqli_real_escape_string($conn, $data['uid_mhs'] ?? '');
$jenis = mysqli_real_escape_string($conn, $data['uid_buku'] ?? 'MAHASISWA'); 

$tabel = ($jenis == 'BUKU') ? 'buku' : 'mahasiswa';
$kolom_uid = ($jenis == 'BUKU') ? 'uid_buku' : 'uid_mhs';

// 1. Cek apakah kartu sudah terdaftar (baik aktif maupun non-aktif)
$cek_data = mysqli_query($conn, "SELECT * FROM $tabel WHERE $kolom_uid = '$uid' LIMIT 1");
$row = mysqli_fetch_assoc($cek_data);

if ($row) {
    if ($row['is_deleted'] == 1) {
        // SKENARIO A: Kartu ada tapi statusnya Non-Aktif -> PULIHKAN
        mysqli_query($conn, "UPDATE $tabel SET is_deleted = 0 WHERE $kolom_uid = '$uid'");
        $nama_item = ($jenis == 'BUKU') ? $row['judul'] : $row['nama'];
        $msg = "PEMULIHAN BERHASIL: Data $jenis ($nama_item) telah diaktifkan kembali secara otomatis.";
        
        mysqli_query($conn, "INSERT INTO scan_log (status, aksi, uid_mhs, uid_buku, message, nama, judul) 
                             VALUES ('ok', 'REGISTRASI', '$uid', '$jenis', '$msg', 'Sistem', 'Restorasi')");
        
        echo json_encode(['status' => 'ok', 'message' => 'Data lama dipulihkan']);
    } else {
        // SKENARIO B: Kartu sudah terdaftar dan masih Aktif -> ERROR
        $msg = "GAGAL: UID ($uid) sudah aktif digunakan dalam sistem.";
        mysqli_query($conn, "INSERT INTO scan_log (status, aksi, uid_mhs, uid_buku, message, nama, judul) 
                             VALUES ('error', 'REGISTRASI', '$uid', '$jenis', '$msg', 'Sistem', 'Duplikat')");
        
        echo json_encode(['status' => 'error', 'message' => 'Sudah aktif']);
    }
} else {
    // SKENARIO C: Kartu Benar-Benar Baru -> DAFTARKAN LOG
    $msg = "SCAN BERHASIL: Kartu $jenis baru terdeteksi. Silakan klik 'Ambil UID' di web.";
    mysqli_query($conn, "INSERT INTO scan_log (status, aksi, uid_mhs, uid_buku, message, nama, judul) 
                         VALUES ('ok', 'REGISTRASI', '$uid', '$jenis', '$msg', 'Baru', 'Menunggu Form')");
    
    echo json_encode(['status' => 'ok', 'message' => 'Siap didaftarkan']);
}
?>