<?php
// file: api/perpanjang.php
require '../koneksi.php';
header('Content-Type: application/json; charset=utf-8');

// ==== CEK METHOD ====
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Gunakan metode POST'
    ]);
    exit;
}

// ==== BACA JSON BODY ====
$raw  = file_get_contents('php://input');
$data = json_decode($raw, true);

if (!$data) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'JSON tidak valid'
    ]);
    exit;
}

$id_trans    = isset($data['id_trans']) ? (int)$data['id_trans'] : 0;
$hari_tambah = isset($data['hari_tambah']) ? (int)$data['hari_tambah'] : 0;

if ($id_trans <= 0 || $hari_tambah <= 0) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Parameter tidak lengkap / tidak valid'
    ]);
    exit;
}

// Batasi, misal maksimal tambah 30 hari sekali
if ($hari_tambah > 30) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Maksimal perpanjangan 30 hari per sekali.'
    ]);
    exit;
}

// ==== AMBIL DATA TRANSAKSI PINJAM ====
$sql = "
    SELECT 
        t.*,
        m.nim,
        m.nama,
        b.judul
    FROM transaksi t
    JOIN mahasiswa m ON t.uid_mhs = m.uid_mhs
    JOIN buku      b ON t.uid_buku = b.uid_buku
    WHERE t.id_trans = $id_trans
      AND t.aksi = 'PINJAM'
    LIMIT 1
";
$res = mysqli_query($conn, $sql);
$pinjam = mysqli_fetch_assoc($res);

if (!$pinjam) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Transaksi PINJAM tidak ditemukan.'
    ]);
    exit;
}

// Pastikan pinjaman ini masih AKTIF (belum ada KEMBALI setelahnya)
$uid_mhs_sql = mysqli_real_escape_string($conn, $pinjam['uid_mhs']);
$uid_buk_sql = mysqli_real_escape_string($conn, $pinjam['uid_buku']);
$ts_pinjam   = mysqli_real_escape_string($conn, $pinjam['timestamp']);

$sqlCek = "
    SELECT 1
    FROM transaksi
    WHERE uid_mhs   = '$uid_mhs_sql'
      AND uid_buku  = '$uid_buk_sql'
      AND aksi      = 'KEMBALI'
      AND timestamp > '$ts_pinjam'
    LIMIT 1
";
$resCek = mysqli_query($conn, $sqlCek);

if (mysqli_num_rows($resCek) > 0) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Pinjaman ini sudah dikembalikan. Tidak bisa diperpanjang.'
    ]);
    exit;
}

// ==== HITUNG DURASI BARU ====
$durasi_lama = (int)($pinjam['durasi_hari'] ?? 7);
if ($durasi_lama <= 0) $durasi_lama = 7;

$durasi_baru = $durasi_lama + $hari_tambah;

// Boleh dibatasi, misal maksimal 90 hari total
if ($durasi_baru > 90) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Durasi total melebihi batas maksimum (90 hari).'
    ]);
    exit;
}

$perpanjang_ke = (int)($pinjam['perpanjang_ke'] ?? 0) + 1;

// Tentukan tgl_pinjam (pakai kolom tgl_pinjam kalau ada, kalau tidak pakai tanggal dari timestamp)
$baseDate = $pinjam['tgl_pinjam'] 
    ? $pinjam['tgl_pinjam'] 
    : substr($pinjam['timestamp'], 0, 10);

$dtPinjam = new DateTime($baseDate);
$dtJatuh  = clone $dtPinjam;
$dtJatuh->modify("+{$durasi_baru} day");
$jatuh_tempo_baru = $dtJatuh->format('d/m/Y');

// ==== UPDATE TRANSAKSI ====
$sqlUpd = "
    UPDATE transaksi
    SET durasi_hari   = $durasi_baru,
        perpanjang_ke = $perpanjang_ke
    WHERE id_trans    = $id_trans
";
if (!mysqli_query($conn, $sqlUpd)) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Gagal memperbarui durasi: ' . mysqli_error($conn)
    ]);
    exit;
}

// Selesai
echo json_encode([
    'status'  => 'ok',
    'message' => "Durasi diperpanjang {$hari_tambah} hari. Jatuh tempo baru: $jatuh_tempo_baru",
    'data'    => [
        'id_trans'        => $id_trans,
        'durasi_lama'     => $durasi_lama,
        'durasi_baru'     => $durasi_baru,
        'perpanjang_ke'   => $perpanjang_ke,
        'jatuh_tempo'     => $jatuh_tempo_baru,
        'nim'             => $pinjam['nim'],
        'nama'            => $pinjam['nama'],
        'judul'           => $pinjam['judul'],
    ]
]);