<?php
// api/notif_reminder.php
require '../koneksi.php';
require '../notif_config.php';

date_default_timezone_set('Asia/Jakarta');

// Jatuh tempo besok
$sqlBesok = "
    SELECT t.*, m.nim, m.nama, m.no_hp, b.judul,
           DATE_ADD(t.tgl_pinjam, INTERVAL t.durasi_hari DAY) AS jatuh_tempo
    FROM transaksi t
    JOIN mahasiswa m ON t.uid_mhs = m.uid_mhs
    JOIN buku      b ON t.uid_buku = b.uid_buku
    WHERE t.aksi='PINJAM'
      AND t.tgl_pinjam IS NOT NULL
      AND (t.tgl_kembali IS NULL OR t.tgl_kembali='0000-00-00')
    HAVING jatuh_tempo = CURDATE() + INTERVAL 1 DAY
";

$resBesok = mysqli_query($conn, $sqlBesok);

if ($resBesok) {
    while ($r = mysqli_fetch_assoc($resBesok)) {
        if (empty($r['no_hp'])) continue;

        $pesan = "Halo {$r['nama']} ({$r['nim']}),\n\n"
            . "Buku yang Anda pinjam akan jatuh tempo BESOK.\n"
            . "Judul : {$r['judul']}\n"
            . "Jatuh tempo : " . date('d/m/Y', strtotime($r['jatuh_tempo'])) . "\n\n"
            . "Mohon segera mengembalikan atau mengajukan perpanjangan.\n"
            . "– Pustaka Ganesha";

        sendWhatsApp($r['no_hp'], $pesan);
    }
}

// Sudah lewat jatuh tempo (terlambat)
$sqlTelat = "
    SELECT t.*, m.nim, m.nama, m.no_hp, b.judul,
           DATE_ADD(t.tgl_pinjam, INTERVAL t.durasi_hari DAY) AS jatuh_tempo
    FROM transaksi t
    JOIN mahasiswa m ON t.uid_mhs = m.uid_mhs
    JOIN buku      b ON t.uid_buku = b.uid_buku
    WHERE t.aksi='PINJAM'
      AND t.tgl_pinjam IS NOT NULL
      AND (t.tgl_kembali IS NULL OR t.tgl_kembali='0000-00-00')
    HAVING jatuh_tempo < CURDATE()
";

$resTelat = mysqli_query($conn, $sqlTelat);

if ($resTelat) {
    while ($r = mysqli_fetch_assoc($resTelat)) {
        if (empty($r['no_hp'])) continue;

        $hariTelat = (strtotime(date('Y-m-d')) - strtotime($r['jatuh_tempo'])) / 86400;
        $hariTelat = (int)$hariTelat;

        $pesan = "Halo {$r['nama']} ({$r['nim']}),\n\n"
            . "Anda TELAT mengembalikan buku perpustakaan.\n"
            . "Judul : {$r['judul']}\n"
            . "Jatuh tempo : " . date('d/m/Y', strtotime($r['jatuh_tempo'])) . "\n"
            . "Keterlambatan : $hariTelat hari\n\n"
            . "Harap segera mengembalikan buku.\n"
            . "– Pustaka Ganesha";

        sendWhatsApp($r['no_hp'], $pesan);
    }
}

echo "Notifikasi jatuh tempo & terlambat sudah diproses.\n";