<?php
// file: api/log_last.php
require '../koneksi.php';
header('Content-Type: application/json; charset=utf-8');

// last_id dari JS (transaksi terakhir yang SUDAH tampil)
$lastId = isset($_GET['last_id']) ? (int)$_GET['last_id'] : 0;

// Ambil transaksi baru (id_trans > lastId)
$sql = "
    SELECT 
        t.id_trans,
        t.uid_mhs,
        t.uid_buku,
        t.aksi,
        t.timestamp,
        t.durasi_hari,
        m.nim,
        m.nama,
        b.judul,
        DATE_FORMAT(t.timestamp,'%d/%m/%Y') AS tgl,
        DATE_FORMAT(t.timestamp,'%H:%i:%s') AS jam,
        DATE_FORMAT(t.timestamp,'%Y-%m-%d %H:%i:%s') AS ts_sort
    FROM transaksi t
    JOIN mahasiswa m ON t.uid_mhs = m.uid_mhs
    JOIN buku      b ON t.uid_buku = b.uid_buku
    WHERE t.id_trans > $lastId
    ORDER BY t.id_trans ASC
    LIMIT 50
";

$res = mysqli_query($conn, $sql);
if (!$res) {
    echo json_encode([
        'status'  => 'error',
        'message' => 'Query error: ' . mysqli_error($conn),
    ]);
    exit;
}

$data  = [];
$maxId = $lastId;

while ($r = mysqli_fetch_assoc($res)) {
    $row = [
        'id_trans'    => (int)$r['id_trans'],
        'aksi'        => $r['aksi'],
        'timestamp'   => $r['timestamp'],
        'timestamp_sort' => $r['ts_sort'],
        'durasi_hari' => $r['durasi_hari'] !== null ? (int)$r['durasi_hari'] : null,
        'nim'         => $r['nim'],
        'nama'        => $r['nama'],
        'judul'       => $r['judul'],
        'uid_mhs'     => $r['uid_mhs'],
        'uid_buku'    => $r['uid_buku'],
        'tgl'         => $r['tgl'],
        'jam'         => $r['jam'],
    ];
    $data[] = $row;
    if ($row['id_trans'] > $maxId) {
        $maxId = $row['id_trans'];
    }
}

if (empty($data)) {
    echo json_encode([
        'status'  => 'empty',
        'last_id' => $lastId,
    ]);
    exit;
}

echo json_encode([
    'status'  => 'ok',
    'last_id' => $maxId,
    'data'    => $data,
]);
