<?php
require 'auth_check.php';
require 'koneksi.php';

if (empty($_SESSION['admin_login'])) {
    header("Location: login.php");
    exit;
}

// 1. TANGKAP SEMUA PARAMETER FILTER
$dari    = $_GET['dari']   ?? date('Y-m-d', strtotime('-30 days'));
$sampai  = $_GET['sampai'] ?? date('Y-m-d');
$status_f = $_GET['status_f'] ?? 'semua';
$search  = mysqli_real_escape_string($conn, $_GET['search'] ?? '');
$sort    = $_GET['sort']   ?? 'terbaru';

$order = ($sort == 'terlama') ? "p.timestamp ASC" : "p.timestamp DESC";

// 2. QUERY DATA
$sql = "SELECT p.timestamp AS ts_pinjam, m.nim, m.nama, b.judul, p.denda, k.timestamp as ts_kembali
        FROM transaksi p
        JOIN mahasiswa m ON p.uid_mhs = m.uid_mhs
        JOIN buku b ON p.uid_buku = b.uid_buku
        LEFT JOIN transaksi k ON k.uid_mhs = p.uid_mhs AND k.uid_buku = p.uid_buku 
             AND k.aksi = 'KEMBALI' AND k.timestamp > p.timestamp
        WHERE p.aksi = 'PINJAM' 
        AND (m.nama LIKE '%$search%' OR m.nim LIKE '%$search%' OR b.judul LIKE '%$search%')
        AND p.timestamp BETWEEN '$dari 00:00:00' AND '$sampai 23:59:59'";

if ($status_f == 'selesai') $sql .= " AND k.timestamp IS NOT NULL";
if ($status_f == 'aktif') $sql .= " AND k.timestamp IS NULL";

$sql .= " ORDER BY $order";
$res = mysqli_query($conn, $sql);

$total_denda = 0;
$total_data = mysqli_num_rows($res);
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Laporan_Transaksi_<?= date('dmy') ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&display=swap" rel="stylesheet">
    <style>
        /* CSS PREMIUM UNTUK LAPORAN */
        body { 
            font-family: 'Inter', sans-serif; 
            color: #334155; 
            margin: 0; 
            padding: 40px;
            background-color: #fff;
        }

        .no-print { 
            background: #fffbeb; 
            color: #92400e; 
            padding: 15px; 
            border-radius: 12px; 
            margin-bottom: 30px; 
            border: 1px solid #fef3c7;
            font-size: 13px;
        }

        .header-laporan { 
            text-align: center; 
            margin-bottom: 40px; 
            border-bottom: 2px solid #f1f5f9;
            padding-bottom: 20px;
        }
        
        .header-laporan h2 { 
            margin: 0; 
            color: #1e293b; 
            letter-spacing: -1px; 
            font-weight: 800;
            text-transform: uppercase;
        }

        .header-laporan p { margin: 5px 0; color: #64748b; font-size: 14px; }

        /* KODE CSS YANG ANDA MINTA */
        table {
            width: 100%;
            border: none;
            margin-top: 20px;
            border-collapse: collapse;
        }
        th {
            background-color: #7C9473 !important; /* Sage Green */
            color: white !important;
            text-transform: uppercase;
            font-size: 11px;
            letter-spacing: 1px;
            padding: 15px 10px !important;
            border: none !important;
            text-align: left;
        }
        td {
            border-bottom: 1px solid #f1f5f9 !important;
            border-left: none !important;
            border-right: none !important;
            padding: 14px 10px !important;
            font-size: 12px;
            color: #334155;
        }
        tr:nth-child(even) {
            background-color: #f8fafc;
        }
        .total-row {
            background-color: #f1f5f9 !important;
            font-weight: 800;
            color: #0f172a;
        }

        .summary-box {
            margin-top: 30px;
            padding: 20px;
            background: #f8fafc;
            border-radius: 15px;
            display: inline-block;
            min-width: 250px;
        }

        .summary-item { display: flex; justify-content: space-between; margin-bottom: 5px; font-size: 13px; }

        .signature {
            margin-top: 50px;
            float: right;
            text-align: center;
            width: 200px;
        }

        @media print {
            .no-print { display: none; }
            body { padding: 0; }
            @page { margin: 1.5cm; }
        }
    </style>
</head>
<body onload="window.print()">

    <div class="no-print">
        <strong>💡 TIPS TAMPILAN BERSIH:</strong> Saat jendela print muncul, klik <strong>More Settings</strong> dan hilangkan centang pada <strong>Headers and Footers</strong> agar URL/Tanggal di pojok kertas hilang.
        <br><br>
        <button onclick="window.print()" style="padding: 8px 16px; border-radius: 8px; border: 1px solid #7C9473; background: #7C9473; color: white; cursor: pointer; font-weight: 600;">Cetak Ulang</button>
        <a href="laporan.php" style="margin-left: 10px; color: #64748b; text-decoration: none;">&larr; Kembali</a>
    </div>

    <div class="header-laporan">
        <h2>Pustaka Ganesha</h2>
        <p>Laporan Rekapitulasi Transaksi Perpustakaan Berbasis RFID</p>
        <p style="font-weight: 600; color: #7C9473;">Periode: <?= date('d/m/Y', strtotime($dari)) ?> - <?= date('d/m/Y', strtotime($sampai)) ?></p>
    </div>

    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Tanggal Pinjam</th>
                <th>NIM</th>
                <th>Mahasiswa</th>
                <th>Judul Buku</th>
                <th style="text-align: right;">Denda</th>
            </tr>
        </thead>
        <tbody>
            <?php 
            $n = 1; 
            while($r = mysqli_fetch_assoc($res)): 
                $total_denda += $r['denda'];
            ?>
            <tr>
                <td><?= $n++ ?></td>
                <td><?= date('d M Y', strtotime($r['ts_pinjam'])) ?></td>
                <td style="font-weight: 600;"><?= $r['nim'] ?></td>
                <td><?= htmlspecialchars($r['nama']) ?></td>
                <td><?= htmlspecialchars($r['judul']) ?></td>
                <td style="text-align: right; font-weight: 700;">Rp <?= number_format($r['denda'], 0, ',', '.') ?></td>
            </tr>
            <?php endwhile; ?>
            
            <tr class="total-row">
                <td colspan="5" style="text-align: right;">TOTAL KESELURUHAN</td>
                <td style="text-align: right;">Rp <?= number_format($total_denda, 0, ',', '.') ?></td>
            </tr>
        </tbody>
    </table>

    <div class="summary-box">
        <div class="summary-item">
            <span>Total Transaksi</span>
            <strong><?= $total_data ?> Data</strong>
        </div>
        <div class="summary-item">
            <span>Status Filter</span>
            <strong style="text-transform: capitalize;"><?= $status_f ?></strong>
        </div>
    </div>

    <div class="signature">
        <p style="font-size: 13px;">Kebumen, <?= date('d F Y') ?></p>
        <p style="font-size: 13px; margin-bottom: 60px;">Petugas Perpustakaan,</p>
        <p><strong>( ________________ )</strong></p>
    </div>

</body>
</html>